/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.pos;

import dev.xkmc.l2library.idea.infmaze.pos.MazeAxis;

public enum MazeDirection {
    EAST(MazeAxis.X, 1),
    WEST(MazeAxis.X, -1),
    UP(MazeAxis.Y, 1),
    DOWN(MazeAxis.Y, -1),
    SOUTH(MazeAxis.Z, 1),
    NORTH(MazeAxis.Z, -1);

    public final MazeAxis axis;
    public final int x;
    public final int y;
    public final int z;
    public final int factor;

    private MazeDirection(MazeAxis axis, int factor) {
        this.axis = axis;
        this.factor = factor;
        this.x = axis.x * factor;
        this.y = axis.y * factor;
        this.z = axis.z * factor;
    }

    public static MazeDirection getDirection(MazeAxis axis, int factor) {
        return MazeDirection.values()[axis.ordinal() << 1 | 1 - factor >> 1];
    }
}

