/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.worldgen;

import dev.xkmc.l2library.idea.infmaze.dim3d.CubeEdge;
import dev.xkmc.l2library.idea.infmaze.dim3d.MazeCell3D;
import dev.xkmc.l2library.idea.infmaze.dim3d.MazeWall3D;
import dev.xkmc.l2library.idea.infmaze.init.InfiniMaze;
import dev.xkmc.l2library.idea.infmaze.pos.BasePos;
import dev.xkmc.l2library.idea.infmaze.pos.BoundBox;
import dev.xkmc.l2library.idea.infmaze.pos.CellPos;
import dev.xkmc.l2library.idea.infmaze.pos.MazeDirection;
import dev.xkmc.l2library.idea.infmaze.pos.WallPos;
import dev.xkmc.l2library.idea.infmaze.worldgen.FrameConfig;
import java.util.TreeSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.RandomState;

public class ChunkFiller {
    private final FrameConfig blocks;
    private final int cellWidth;
    private final int heightInCell;
    private final int xzCount;

    public ChunkFiller(int cellWidth, int scale, FrameConfig blocks) {
        this.cellWidth = cellWidth;
        this.blocks = blocks;
        this.heightInCell = 1 << scale;
        this.xzCount = 16 / cellWidth;
    }

    public void fillChunk(InfiniMaze maze, ChunkPos pos, ChunkAccess access, RandomState random) {
        TreeSet<CellPos> complete = new TreeSet<CellPos>();
        for (long y = 0L; y < (long)this.heightInCell; ++y) {
            for (long x = 0L; x < (long)this.xzCount; ++x) {
                for (long z = 0L; z < (long)this.xzCount; ++z) {
                    long px = x | (long)pos.f_45578_ * (long)this.xzCount;
                    long pz = z | (long)pos.f_45579_ * (long)this.xzCount;
                    MazeCell3D cell = maze.getCell(new BasePos(px, y, pz)).load();
                    if (complete.contains(cell.pos)) continue;
                    this.fillCell(cell, pos, access, random);
                    complete.add(cell.pos);
                }
            }
        }
    }

    private void fillCell(MazeCell3D cell, ChunkPos pos, ChunkAccess access, RandomState random) {
        BasePos c0 = new BasePos((long)pos.f_45578_ << 4, 0L, (long)pos.f_45579_ << 4);
        BasePos c1 = new BasePos((long)(pos.f_45578_ + 1) << 4, (long)this.heightInCell * (long)this.cellWidth, (long)(pos.f_45579_ + 1) << 4);
        BoundBox boxC = new BoundBox(c0, c1);
        for (CubeEdge cubeEdge : CubeEdge.EDGES) {
            BasePos start = new BasePos(cubeEdge.x(), cubeEdge.y(), cubeEdge.z()).scale(1 << cell.pos.scale());
            BasePos p0 = cell.pos.pos().offset(start.x(), start.y(), start.z()).scale(this.cellWidth);
            BasePos p1 = p0.offset(MazeDirection.getDirection(cubeEdge.axis(), 1), (long)this.cellWidth << cell.pos.scale());
            this.fillSolidBox(boxC.intersect(new BoundBox(p0, p1).inflate(1, 1, 1)), this.blocks.hard(), access);
        }
        for (MazeDirection mazeDirection : MazeDirection.values()) {
            MazeWall3D wall = cell.getWall(mazeDirection);
            this.fillWallRecursive(boxC, wall, cell.pos.scale() == 0 ? this.blocks.wall() : this.blocks.hard(), access);
        }
        if (cell.content != null) {
            cell.content.generate(random, boxC, access);
        }
    }

    private void fillWallRecursive(BoundBox chunk, MazeWall3D wall, BlockState block, ChunkAccess access) {
        BoundBox boxW = new BoundBox(wall.pos.pos(), wall.pos.getMaxEnd()).inflate(this.cellWidth).inflate(-1, -1, -1).inflate(MazeDirection.getDirection(wall.pos.normal(), 1), 2);
        BoundBox inter = chunk.intersect(boxW);
        if (inter.size() > 0L) {
            if (wall.open) {
                if (wall.pos.scale() == 0) {
                    return;
                }
                for (int i = 0; i < 4; ++i) {
                    MazeWall3D subWall = wall.loadChild(i);
                    this.fillWallRecursive(chunk, subWall, block, access);
                }
                long len = 1L << wall.pos.scale() - 1;
                WallPos e0 = wall.pos.offset(len, 0L, 0);
                WallPos e1 = wall.pos.offset(0L, len, 0);
                WallPos e2 = e0.offset(0L, len << 1, 0);
                WallPos e3 = e1.offset(len << 1, 0L, 0);
                BoundBox b0 = new BoundBox(e0.pos(), e2.pos()).inflate(this.cellWidth).inflate(1, 1, 1);
                BoundBox b1 = new BoundBox(e1.pos(), e3.pos()).inflate(this.cellWidth).inflate(1, 1, 1);
                this.fillSolidBox(chunk.intersect(b0), block, access);
                this.fillSolidBox(chunk.intersect(b1), block, access);
            } else {
                this.fillSolidBox(inter, block, access);
            }
        }
    }

    private void fillSolidBox(BoundBox inter, BlockState block, ChunkAccess access) {
        if (inter.size() <= 0L) {
            return;
        }
        BlockPos.MutableBlockPos bp = new BlockPos.MutableBlockPos();
        for (long x = inter.p0().x(); x < inter.p1().x(); ++x) {
            for (long z = inter.p0().z(); z < inter.p1().z(); ++z) {
                for (long y = inter.p0().y(); y < inter.p1().y(); ++y) {
                    bp.m_122169_((double)x, (double)y, (double)z);
                    access.m_6978_((BlockPos)bp, block, false);
                }
            }
        }
    }
}

