/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.magic;

import dev.xkmc.l2library.idea.magic.HexDirection;
import dev.xkmc.l2library.idea.magic.HexHandler;
import dev.xkmc.l2library.idea.magic.LocateResult;

public class ArrowResult
extends LocateResult {
    public final int row;
    public final int cell;
    public final HexDirection dir;
    private final HexHandler hex;

    ArrowResult(int row, int cell, HexDirection dir, HexHandler hex) {
        this.row = row;
        this.cell = cell;
        this.dir = dir;
        this.hex = hex;
    }

    public static LocateResult get(int row, int cell, HexDirection dir, HexHandler hex) {
        if (row < 0 || row >= hex.getRowCount()) {
            return null;
        }
        if (cell < 0 || cell >= hex.getCellCount(row)) {
            return null;
        }
        int dr = dir.getRowOffset();
        int dc = dir.getCellOffset(hex.radius, row, cell);
        if (row + dr < 0 || row + dr >= hex.getRowCount()) {
            return null;
        }
        if (cell + dc < 0 || cell + dc >= hex.getCellCount(row + dr)) {
            return null;
        }
        return new ArrowResult(row, cell, dir, hex);
    }

    public boolean equals(LocateResult loc) {
        if (loc instanceof ArrowResult) {
            ArrowResult arr = (ArrowResult)loc;
            return arr.row == this.row && arr.cell == this.cell && arr.dir == this.dir;
        }
        return false;
    }

    @Override
    public LocateResult.ResultType getType() {
        return LocateResult.ResultType.ARROW;
    }

    @Override
    public double getX() {
        int dr = this.dir.getRowOffset();
        int dc = this.dir.getCellOffset(this.hex.radius, this.row, this.cell);
        double x0 = this.hex.getX(this.row, this.cell);
        double x1 = this.hex.getX(this.row + dr, this.cell + dc);
        return (x0 + x1) / 2.0;
    }

    @Override
    public double getY() {
        int dr = this.dir.getRowOffset();
        int dc = this.dir.getCellOffset(this.hex.radius, this.row, this.cell);
        double y0 = this.hex.getY(this.row, this.cell);
        double y1 = this.hex.getY(this.row + dr, this.cell + dc);
        return (y0 + y1) / 2.0;
    }

    public String toString() {
        return "(" + this.row + "," + this.cell + ") to " + this.dir.ind;
    }
}

