/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.magic;

import dev.xkmc.l2library.idea.magic.ArrowResult;
import dev.xkmc.l2library.idea.magic.CellResult;
import dev.xkmc.l2library.idea.magic.FlowChart;
import dev.xkmc.l2library.idea.magic.HexCalc;
import dev.xkmc.l2library.idea.magic.HexCell;
import dev.xkmc.l2library.idea.magic.HexDirection;
import dev.xkmc.l2library.idea.magic.HexException;
import dev.xkmc.l2library.idea.magic.LocateResult;
import dev.xkmc.l2library.idea.magic.SubHex;
import dev.xkmc.l2library.util.math.Frac;
import dev.xkmc.l2library.util.nbt.NBTList;
import dev.xkmc.l2library.util.nbt.NBTObj;

public class HexHandler {
    public static final int CORE_LIMIT = 6;
    public static final double WIDTH = 2.0;
    public static final double HEIGHT = Math.sqrt(3.0);
    public final int radius;
    public final SubHex[] subhex;
    public final SubHexCore[] cores;
    final byte[][] cells;

    public HexHandler(int r) {
        this.radius = r;
        this.cells = new byte[this.getRowCount()][];
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.cells[i] = new byte[this.getCellCount(i)];
        }
        this.subhex = new SubHex[this.getArea()];
        this.cores = new SubHexCore[6];
    }

    public HexHandler(NBTObj tag) {
        int i;
        byte[] data = tag.tag.m_128463_("data");
        byte[] subs = tag.tag.m_128463_("subs");
        NBTList list = tag.getList("cores");
        this.radius = data[0] & 0xF;
        this.cells = new byte[this.getRowCount()][];
        for (i = 0; i < this.getRowCount(); ++i) {
            this.cells[i] = new byte[this.getCellCount(i)];
        }
        this.subhex = new SubHex[this.getArea()];
        this.cores = new SubHexCore[6];
        for (i = 0; i < list.size(); ++i) {
            this.cores[i] = new SubHexCore(new HexHandler(list.get(i)));
        }
        int k = 1;
        int s = 0;
        HexCell cell = new HexCell(this, 0, 0);
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            for (int j = 0; j < this.getCellCount(i2); ++j) {
                cell.row = i2;
                cell.cell = j;
                int val = data[k >> 1] >> (k & 1) * 4;
                byte dir = (byte)(val & 7);
                for (int d = 0; d < 3; ++d) {
                    if ((HexDirection.values()[d].mask() & dir) == 0) continue;
                    cell.toggle(HexDirection.values()[d]);
                }
                if ((val & 8) != 0) {
                    byte sval = subs[s++];
                    SubHexCore core = this.cores[sval & 7];
                    int rot = sval >> 3 & 7;
                    boolean flip = (sval >> 6 & 1) != 0;
                    this.subhex[this.getInd((int)i2, (int)j)] = new SubHex(core, rot, flip);
                }
                ++k;
            }
        }
    }

    private static CellResult getCoordinate(double x, double y) {
        int row = (int)Math.floor(y / HEIGHT + 0.5);
        double rel_y = y - (double)row * HEIGHT;
        int cell = (int)Math.floor(x / 2.0 + 0.5 - (double)Math.abs(row) * 0.5);
        double rel_x = x - ((double)Math.abs(row) * 0.5 + (double)cell) * 2.0;
        double xoff = 0.5;
        double yoff = HEIGHT / 6.0;
        HexDirection dire = rel_y > 0.0 ? (rel_x > 0.0 ? HexDirection.LOWER_RIGHT : HexDirection.LOWER_LEFT) : (rel_x > 0.0 ? HexDirection.UPPER_RIGHT : HexDirection.UPPER_LEFT);
        rel_x = Math.abs(rel_x) - xoff;
        rel_y = Math.abs(rel_y) - yoff * 2.0;
        if (rel_x > 0.0 && rel_y > 0.0 && rel_x / xoff + rel_y / yoff > 1.0) {
            cell += dire.getCellOffset(0, row, cell);
            row += dire.getRowOffset();
        }
        return new CellResult(row, cell, null);
    }

    public int getArea() {
        return 3 * this.radius * (this.radius + 1) + 1;
    }

    public int getCellCount(int row) {
        return Math.min(row, this.radius * 2 - row) + this.radius + 1;
    }

    public CellResult getCellOnHex(double x, double y) {
        CellResult pos = HexHandler.getCoordinate(x, y);
        return CellResult.get(pos.getRow() + this.radius, pos.getCell() + this.radius, this);
    }

    public LocateResult getElementOnHex(double x, double y) {
        CellResult pos = HexHandler.getCoordinate(x * 2.0, y * 2.0);
        int trow = Math.floorDiv(pos.getRow(), 2) + this.radius;
        int tcel = Math.floorDiv(pos.getCell(), 2) + this.radius;
        if (pos.getRow() % 2 == 0 && pos.getCell() % 2 == 0) {
            return CellResult.get(trow, tcel, this);
        }
        if (pos.getRow() % 2 == 0) {
            return ArrowResult.get(trow, tcel, HexDirection.RIGHT, this);
        }
        if (pos.getRow() < 0) {
            return ArrowResult.get(trow, tcel, pos.getCell() % 2 == 0 ? HexDirection.LOWER_LEFT : HexDirection.LOWER_RIGHT, this);
        }
        if (pos.getCell() % 2 == 0) {
            return ArrowResult.get(trow, tcel, HexDirection.LOWER_RIGHT, this);
        }
        return ArrowResult.get(trow, tcel + 1, HexDirection.LOWER_LEFT, this);
    }

    public int getInd(int row, int cell) {
        if (row <= this.radius) {
            return (2 * this.radius + 1 + row) * row / 2 + cell;
        }
        return this.getArea() - (4 * this.radius + 2 - row) * (2 * this.radius + 1 - row) / 2 + cell;
    }

    public FlowChart getMatrix(boolean withFlow) {
        return new HexCalc(this).getMatrix(withFlow);
    }

    public int getRowCount() {
        return this.radius * 2 + 1;
    }

    public double getX(int row, int cell) {
        return (double)(cell - this.radius) * 2.0 + (double)(this.radius * 2 + 1 - this.getCellCount(row)) * 2.0 / 2.0;
    }

    public double getY(int row, int cell) {
        return (double)(row - this.radius) * HEIGHT;
    }

    public boolean isInvalid() {
        HexCell cell = new HexCell(this, 0, 0);
        for (int r = 0; r < this.cells.length; ++r) {
            int c = 0;
            while (c < this.cells[r].length) {
                cell.row = r;
                cell.cell = c++;
                if (!cell.isInvalid()) continue;
                return true;
            }
        }
        return false;
    }

    public NBTObj write(NBTObj tag) {
        int tot = this.getArea() * 4 + 4;
        int len = tot >> 3;
        byte[] data = new byte[len];
        SubHex[] sub = new SubHex[this.getArea()];
        data[0] = (byte)(data[0] | this.radius & 0xF);
        int k = 1;
        int s = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getCellCount(i); ++j) {
                int n = k >> 1;
                data[n] = (byte)(data[n] | (this.cells[i][j] & 7) << (k & 1) * 4);
                if (this.subhex[this.getInd(i, j)] != null) {
                    int n2 = k >> 1;
                    data[n2] = (byte)(data[n2] | 8 << (k & 1) * 4);
                    sub[s] = this.subhex[this.getInd(i, j)];
                    ++s;
                }
                ++k;
            }
        }
        tag.tag.m_128382_("data", data);
        byte[] subs = new byte[s];
        for (int i = 0; i < s; ++i) {
            int n = i;
            subs[n] = (byte)(subs[n] | sub[i].core.index);
            int n3 = i;
            subs[n3] = (byte)(subs[n3] | (sub[i].rotation + 6) % 6 << 3);
            int n4 = i;
            subs[n4] = (byte)(subs[n4] | (sub[i].flip ? 1 : 0) << 6);
        }
        tag.tag.m_128382_("subs", subs);
        NBTList list = tag.getList("cores");
        for (SubHexCore core : this.cores) {
            if (core == null) continue;
            core.hex.write(list.add());
        }
        return tag;
    }

    public class SubHexCore {
        public final HexHandler hex;
        public final Frac[][] otho;
        public final int exist;
        public final int index;

        public SubHexCore(HexHandler hex) {
            int i;
            this.hex = hex;
            this.otho = hex.getMatrix((boolean)false).matrix;
            int exi = 0;
            for (i = 0; i < 6; ++i) {
                int dc;
                int c;
                HexDirection dir = HexDirection.values()[i];
                int dr = dir.getRowOffset();
                int r = (dr + 1) * hex.radius;
                if (hex.cells[r][c = ((dc = dir.getCellOffset(hex.radius, hex.radius, hex.radius)) + 1) * hex.radius] == 0) continue;
                exi |= 1 << i;
            }
            this.exist = exi;
            for (i = 0; i < HexHandler.this.cores.length; ++i) {
                if (HexHandler.this.cores[i] != null) continue;
                HexHandler.this.cores[i] = this;
                this.index = i;
                return;
            }
            throw new HexException("no core space");
        }
    }
}

