/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.maze.generator;

import dev.xkmc.l2library.idea.maze.generator.IRandom;
import dev.xkmc.l2library.idea.maze.generator.MazeGen;

public class MazeConfig {
    private static final int[] PATH = new int[]{3, 6, 51, 0, 0, 0, 0};
    private static final int[] LOOP = new int[]{5, 55, 0, 0, 0, 0, 0};
    private static final double PATH_FAC = 0.35;
    private static final double LOOP_FAC = 0.65;
    private static final double CONN_PRI = 0.05;
    private static final double CONN_SEC = 0.75;
    public int[] path;
    public int[] loop;
    public double path_fac;
    public double loop_fac;
    public double conn_pri;
    public double conn_sec;
    public int invariant = 0;
    public int survive = 0;
    public int[][] INVARIANCE_RIM = new int[0][];

    public MazeConfig() {
        this.path = PATH;
        this.loop = LOOP;
        this.path_fac = 0.35;
        this.loop_fac = 0.65;
        this.conn_pri = 0.05;
        this.conn_sec = 0.75;
    }

    public MazeConfig(int[] p, int[] l, double pf, double lf, double c0, double c1) {
        this.path = p;
        this.loop = l;
        this.path_fac = pf;
        this.loop_fac = lf;
        this.conn_pri = c0;
        this.conn_sec = c1;
    }

    public boolean testConn(IRandom r, boolean b) {
        return b ? r.nextDouble() < this.conn_pri : r.nextDouble() < this.conn_sec;
    }

    int randLoop(int i, MazeGen.StateRim rim, IRandom r) {
        if (i < this.invariant) {
            return 0;
        }
        int len = (int)Math.ceil((double)rim.aviLoop() * this.loop_fac);
        return this.randSel(r, this.loop, rim.path == 0, len);
    }

    int randPath(int i, MazeGen.StateRim rim, IRandom r, int c) {
        if (i <= this.invariant) {
            return i <= 1 ? 1 : (i == 2 ? 4 : 1);
        }
        int len = (int)Math.ceil((double)rim.aviPath() * this.path_fac);
        return this.randSel(r, this.path, i < this.survive || c == 1 || !rim.state.isRoot(), len);
    }

    private int randSel(IRandom r, int[] arr, boolean beg, int len) {
        int i;
        int a = 0;
        int b = 0;
        for (i = 0; i < arr.length; ++i) {
            b += arr[i];
        }
        if (beg) {
            a += arr[0];
        }
        for (i = len + 1; i < arr.length; ++i) {
            b -= arr[i];
        }
        int v = a + r.nextInt(b - a);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (v < arr[i2]) {
                return i2;
            }
            v -= arr[i2];
        }
        return arr.length - 1;
    }
}

