/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.maze.objective;

import dev.xkmc.l2library.idea.maze.objective.MazeCellData;
import dev.xkmc.l2library.idea.maze.objective.MazeGeneralData;

public class FarpointObjective
extends MazeCellData<FarpointObjective, MazeGeneralData> {
    public int to_root;
    public int internal;

    public void fillData(MazeGeneralData global, FarpointObjective[] children) {
        int count = children.length;
        if (count == 0) {
            this.to_root = 1;
            this.internal = 1;
        } else if (count == 1) {
            this.to_root = children[0].to_root + 1;
            this.internal = Math.max(this.to_root, children[0].internal);
        } else {
            int max_to_root = 0;
            int max_internal = 0;
            int second_to_root = 0;
            for (FarpointObjective obj : children) {
                if (obj.to_root >= max_to_root) {
                    second_to_root = max_to_root;
                    max_to_root = obj.to_root;
                } else if (obj.to_root > second_to_root) {
                    second_to_root = obj.to_root;
                }
                max_internal = Math.max(max_internal, obj.internal);
            }
            this.to_root = max_to_root + 1;
            this.internal = Math.max(max_internal, max_to_root + second_to_root + 1);
        }
    }

    @Override
    public double getResult() {
        return this.internal;
    }
}

