/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.maze.objective;

import dev.xkmc.l2library.idea.maze.objective.MazeCellData;
import dev.xkmc.l2library.idea.maze.objective.MazeGeneralData;

public class LeafMarker
extends MazeCellData<LeafMarker, LeafSetData> {
    private int color = 0;
    public int level = 0;
    public LeafMarker parent;

    public void fillData(LeafSetData global, LeafMarker[] children) {
        for (LeafMarker c : children) {
            c.parent = this;
        }
        if (children.length == 0) {
            this.level = 0;
        } else if (children.length == 1) {
            this.level = children[0].level;
        } else {
            for (LeafMarker c : children) {
                this.level = Math.max(this.level, c.level + 1);
                c.color = ++global.current_color;
            }
        }
    }

    public boolean isLeaf(int[] colors) {
        return this.level == 0 && colors[this.getColor()] != 0;
    }

    public int getColor() {
        if (this.parent == null) {
            return this.color;
        }
        if (this.color != 0) {
            return this.color;
        }
        return this.parent.getColor();
    }

    @Override
    public double getResult() {
        return this.level;
    }

    public static class LeafSetData
    extends MazeGeneralData {
        public int current_color = 0;
    }
}

