/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init.events.attack;

import dev.xkmc.l2library.init.events.attack.AttackEventHandler;
import dev.xkmc.l2library.init.events.attack.Stage;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;

public class AttackCache {
    int recursive = 0;
    private boolean damageFrozen = true;
    private Stage stage = Stage.PREINIT;
    private AttackEntityEvent player;
    private CriticalHitEvent crit;
    private LivingAttackEvent attack;
    private LivingHurtEvent hurt;
    private LivingDamageEvent damage;
    private LivingEntity target;
    private LivingEntity attacker;
    private ItemStack weapon = ItemStack.f_41583_;
    private float strength = -1.0f;
    private float damage_pre;
    private float damage_modified;
    private float damage_dealt;

    @Nullable
    public static LivingEntity resolve(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            return le;
        }
        if (entity instanceof PartEntity) {
            PartEntity pe = (PartEntity)entity;
            if (pe.getParent() == pe) {
                return null;
            }
            return AttackCache.resolve(pe.getParent());
        }
        return null;
    }

    void pushPlayer(AttackEntityEvent event) {
        this.stage = Stage.PLAYER_ATTACK;
        this.player = event;
        this.strength = event.getEntity().m_36403_(1.0f);
        this.target = AttackCache.resolve(event.getTarget());
        AttackEventHandler.LISTENERS.forEach(e -> e.onPlayerAttack(this));
    }

    void pushCrit(CriticalHitEvent event) {
        this.stage = Stage.CRITICAL_HIT;
        this.crit = event;
        this.target = AttackCache.resolve(event.getTarget());
        AttackEventHandler.LISTENERS.forEach(e -> e.onCriticalHit(this));
    }

    void pushAttackPre(LivingAttackEvent event) {
        this.stage = Stage.HURT_PRE;
        this.attack = event;
        this.target = this.attack.getEntity();
        this.damage_pre = event.getAmount();
        AttackEventHandler.LISTENERS.forEach(e -> e.onAttack(this, this.weapon));
    }

    void pushAttackPost(LivingAttackEvent event) {
        this.stage = Stage.HURT_POST;
    }

    void pushHurtPre(LivingHurtEvent event) {
        this.stage = Stage.ACTUALLY_HURT_PRE;
        this.hurt = event;
        this.damage_modified = event.getAmount();
        this.damageFrozen = false;
        AttackEventHandler.LISTENERS.forEach(e -> e.onHurt(this, this.weapon));
        this.damageFrozen = true;
        if (this.damage_modified != event.getAmount()) {
            event.setAmount(this.damage_modified);
        }
        AttackEventHandler.LISTENERS.forEach(e -> e.onHurtMaximized(this, this.weapon));
    }

    void pushHurtPost(LivingHurtEvent event) {
        this.stage = Stage.ACTUALLY_HURT_POST;
    }

    void pushDamage(LivingDamageEvent event) {
        this.stage = Stage.DAMAGE;
        this.damage = event;
        this.damage_dealt = event.getAmount();
        AttackEventHandler.LISTENERS.forEach(e -> e.onDamage(this, this.weapon));
        if (this.damage_dealt != event.getAmount()) {
            event.setAmount(this.damage_dealt);
        }
        AttackEventHandler.LISTENERS.forEach(e -> e.onDamageFinalized(this, this.weapon));
    }

    void setupAttackerProfile(LivingEntity entity, ItemStack stack) {
        this.attacker = entity;
        this.weapon = stack;
    }

    public Stage getStage() {
        return this.stage;
    }

    @Nullable
    public AttackEntityEvent getPlayerAttackEntityEvent() {
        return this.player;
    }

    @Nullable
    public CriticalHitEvent getCriticalHitEvent() {
        return this.crit;
    }

    @Nullable
    public LivingAttackEvent getLivingAttackEvent() {
        return this.attack;
    }

    @Nullable
    public LivingHurtEvent getLivingHurtEvent() {
        return this.hurt;
    }

    @Nullable
    public LivingDamageEvent getLivingDamageEvent() {
        return this.damage;
    }

    @Nullable
    public LivingEntity getAttackTarget() {
        return this.target;
    }

    public LivingEntity getAttacker() {
        return this.attacker;
    }

    public ItemStack getWeapon() {
        return this.weapon;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getDamageOriginal() {
        if (this.stage.ordinal() < Stage.HURT_PRE.ordinal()) {
            throw new IllegalStateException("dealt damage not calculated yet");
        }
        return this.damage_pre;
    }

    public float getDamageModified() {
        if (this.stage.ordinal() < Stage.ACTUALLY_HURT_PRE.ordinal()) {
            throw new IllegalStateException("dealt damage not calculated yet");
        }
        return this.damage_modified;
    }

    public void setDamageModified(float damage) {
        if (this.damageFrozen) {
            throw new IllegalStateException("modify hurt damage only on onHurt event.");
        }
        this.damage_modified = damage;
    }

    public float getDamageDealt() {
        if (this.stage.ordinal() < Stage.DAMAGE.ordinal()) {
            throw new IllegalStateException("actual damage not calculated yet");
        }
        return this.damage_dealt;
    }

    public void setDamageDealt(float damage) {
        if (this.stage != Stage.DAMAGE) {
            throw new IllegalStateException("set actual damage only on onDamage event.");
        }
        this.damage_dealt = damage;
    }
}

