/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init.events.attack;

import dev.xkmc.l2library.init.L2Library;
import dev.xkmc.l2library.init.events.attack.AttackCache;
import dev.xkmc.l2library.init.events.attack.AttackListener;
import dev.xkmc.l2library.init.events.attack.Stage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AttackEventHandler {
    public static final ArrayList<AttackListener> LISTENERS = new ArrayList();
    private static final HashMap<UUID, AttackCache> CACHE = new HashMap();

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = new AttackCache();
        cache.pushPlayer(event);
        if (cache.getAttackTarget() != null) {
            CACHE.put(cache.getAttackTarget().m_20148_(), cache);
        }
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        if (event.getTarget().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity target = AttackCache.resolve(event.getTarget());
        if (target == null) {
            return;
        }
        AttackCache cache = CACHE.get(target.m_20148_());
        if (cache == null) {
            cache = new AttackCache();
        }
        cache.pushCrit(event);
        if (cache.getAttackTarget() != null) {
            CACHE.put(cache.getAttackTarget().m_20148_(), cache);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackPre(LivingAttackEvent event) {
        boolean replace;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (CACHE.size() > 1000) {
            L2Library.LOGGER.error("attack cache too large: " + CACHE.size());
            CACHE.clear();
            return;
        }
        UUID id = event.getEntity().m_20148_();
        AttackCache cache = CACHE.get(id);
        if (cache != null && cache.getStage() == Stage.HURT_PRE) {
            ++cache.recursive;
            return;
        }
        boolean bl = replace = cache == null;
        if (!replace) {
            boolean bl2 = replace = cache.getStage().ordinal() >= Stage.HURT_PRE.ordinal();
        }
        if (!replace && cache.getPlayerAttackEntityEvent() != null && event.getSource().m_7639_() != null) {
            boolean bl3 = replace = event.getSource().m_7639_() != cache.getPlayerAttackEntityEvent().getEntity();
        }
        if (replace) {
            cache = new AttackCache();
            CACHE.put(id, cache);
        }
        cache.pushAttackPre(event);
        DamageSource source = event.getSource();
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            ItemStack stack = entity2.m_21205_();
            cache.setupAttackerProfile(entity2, stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttackPost(LivingAttackEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.HURT_PRE) {
            if (cache.recursive > 0) {
                --cache.recursive;
                return;
            }
            cache.pushAttackPost(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onActuallyHurtPre(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.HURT_POST) {
            cache.pushHurtPre(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onActuallyHurtPost(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.ACTUALLY_HURT_PRE) {
            cache.pushHurtPost(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDamagePost(LivingDamageEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        AttackCache cache = CACHE.get(event.getEntity().m_20148_());
        if (cache != null && cache.getStage() == Stage.ACTUALLY_HURT_POST) {
            cache.pushDamage(event);
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        CACHE.clear();
    }
}

