/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.handler;

import com.google.gson.JsonElement;
import dev.xkmc.l2library.serial.handler.Handlers;
import dev.xkmc.l2library.serial.handler.JsonClassHandler;
import dev.xkmc.l2library.serial.handler.NBTClassHandler;
import dev.xkmc.l2library.serial.handler.PacketClassHandler;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class ClassHandler<R extends Tag, T>
implements JsonClassHandler<T>,
NBTClassHandler<R, T>,
PacketClassHandler<T> {
    public final Function<Object, JsonElement> toJson;
    public final Function<JsonElement, ?> fromJson;
    public final Function<FriendlyByteBuf, ?> fromPacket;
    public final BiConsumer<FriendlyByteBuf, Object> toPacket;
    public final Function<Tag, ?> fromTag;
    public final Function<Object, Tag> toTag;

    @ParametersAreNullableByDefault
    public ClassHandler(@Nonnull Class<T> cls, Function<T, JsonElement> tj, Function<JsonElement, T> fj, Function<FriendlyByteBuf, T> fp, BiConsumer<FriendlyByteBuf, T> tp, Function<R, T> ft, Function<T, Tag> tt, Class<?> ... others) {
        this.toJson = tj;
        this.fromJson = fj;
        this.fromPacket = fp;
        this.toPacket = tp;
        this.fromTag = ft;
        this.toTag = tt;
        this.put(cls);
        for (Class<?> c : others) {
            this.put(c);
        }
    }

    private void put(Class<?> cls) {
        if (this.toJson != null && this.fromJson != null) {
            Handlers.JSON_MAP.put(cls, this);
        }
        if (this.fromTag != null && this.toTag != null) {
            Handlers.NBT_MAP.put(cls, this);
        }
        if (this.fromPacket != null && this.toPacket != null) {
            Handlers.PACKET_MAP.put(cls, this);
        }
    }

    @Override
    public T fromTag(Tag tag) {
        return (T)this.fromTag.apply(tag);
    }

    @Override
    public R toTag(Object obj) {
        return (R)this.toTag.apply(obj);
    }

    @Override
    public JsonElement toJson(Object obj) {
        return this.toJson.apply(obj);
    }

    @Override
    public T fromJson(JsonElement e) {
        return (T)this.fromJson.apply(e);
    }

    @Override
    public void toPacket(FriendlyByteBuf buf, Object obj) {
        this.toPacket.accept(buf, obj);
    }

    @Override
    public T fromPacket(FriendlyByteBuf buf) {
        return (T)this.fromPacket.apply(buf);
    }
}

