/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.handler;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xkmc.l2library.serial.stack.EnchantmentStackCodec;
import dev.xkmc.l2library.serial.stack.JsonStackCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class StackHelper {
    private static final Gson GSON = new Gson();
    private static final List<JsonStackCodec> LIST = new ArrayList<JsonStackCodec>();

    public static void add(JsonStackCodec codec) {
        LIST.add(codec);
    }

    public static JsonElement serializeItemStack(ItemStack stack) {
        for (JsonStackCodec codec : LIST) {
            Optional<JsonElement> result = codec.serialize(stack);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return StackHelper.serializeForgeItemStack(stack);
    }

    public static JsonElement serializeForgeItemStack(ItemStack stack) {
        JsonObject ans = new JsonObject();
        ans.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            ans.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            ans.addProperty("nbt", stack.m_41783_().toString());
        }
        return ans;
    }

    public static ItemStack deserializeItemStack(JsonElement elem) {
        for (JsonStackCodec codec : LIST) {
            Optional<ItemStack> result = codec.deserialize(elem);
            if (!result.isPresent()) continue;
            return result.get();
        }
        JsonObject obj = elem.getAsJsonObject();
        return CraftingHelper.getItemStack((JsonObject)obj, (boolean)true, (boolean)false);
    }

    public static FluidStack deserializeFluidStack(JsonElement e) {
        JsonObject json = e.getAsJsonObject();
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(id);
        if (fluid == null) {
            throw new JsonSyntaxException("Unknown fluid '" + id + "'");
        }
        int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        FluidStack stack = new FluidStack(fluid, amount);
        if (!json.has("nbt")) {
            return stack;
        }
        try {
            JsonElement element = json.get("nbt");
            stack.setTag(TagParser.m_129359_((String)(element.isJsonObject() ? GSON.toJson(element) : GsonHelper.m_13805_((JsonElement)element, (String)"nbt"))));
        }
        catch (CommandSyntaxException err) {
            err.printStackTrace();
        }
        return stack;
    }

    public static JsonElement serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    static {
        StackHelper.add(new EnchantmentStackCodec());
    }
}

