/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.util.raytrace;

import com.google.common.collect.Maps;
import dev.xkmc.l2library.init.L2Library;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2library.util.raytrace.EntityTarget;
import dev.xkmc.l2library.util.raytrace.TargetSetPacket;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceUtil {
    public static final int CLIENT_TIMEOUT = 100;
    public static final int SERVER_TIMEOUT = 200;
    public static final EntityTarget TARGET = new EnderEntityTarget();
    public static final ConcurrentMap<UUID, ServerTarget> TARGET_MAP = Maps.newConcurrentMap();

    @Nullable
    public static EntityHitResult rayTraceEntity(Player player, double reach, Predicate<Entity> pred) {
        Level world = player.f_19853_;
        Vec3 pos = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Vec3 end = RayTraceUtil.getRayTerm(pos, player.m_146909_(), player.m_146908_(), reach);
        AABB box = new AABB(pos, end).m_82400_(1.0);
        return ProjectileUtil.m_37304_((Level)world, (Entity)player, (Vec3)pos, (Vec3)end, (AABB)box, pred);
    }

    public static BlockHitResult rayTraceBlock(Level worldIn, Player player, double reach) {
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        Vec3 Vector3d = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Vec3 Vector3d1 = RayTraceUtil.getRayTerm(Vector3d, xRot, yRot, reach);
        return worldIn.m_45547_(new ClipContext(Vector3d, Vector3d1, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static Vec3 getRayTerm(Vec3 pos, float xRot, float yRot, double reach) {
        float f2 = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-xRot * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        return pos.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
    }

    public static void serverTick() {
        TARGET_MAP.entrySet().removeIf(e -> {
            Optional<ServerPlayer> player = Proxy.getServer().map(MinecraftServer::m_6846_).map(x -> x.m_11259_((UUID)e.getKey()));
            if (player.isEmpty()) {
                return true;
            }
            ServerTarget target = (ServerTarget)e.getValue();
            Entity entity = ((ServerLevel)player.get().f_19853_).m_8791_(target.target);
            if (entity == null || entity.m_213877_() || !entity.m_6084_()) {
                return true;
            }
            ++target.time;
            return target.time >= 200;
        });
    }

    public static void sync(TargetSetPacket packet) {
        if (packet.target == null) {
            TARGET_MAP.remove(packet.player);
        } else if (TARGET_MAP.containsKey(packet.player)) {
            ServerTarget target = (ServerTarget)TARGET_MAP.get(packet.player);
            target.target = packet.target;
            target.time = 0;
        } else {
            TARGET_MAP.put(packet.player, new ServerTarget(packet.target));
        }
    }

    public static void clientUpdateTarget(Player player, double range) {
        double sq;
        Predicate<Entity> predicate;
        AABB aabb;
        Vec3 vec31;
        Vec3 vec32;
        Vec3 vec3;
        EntityHitResult result;
        if (player.f_19853_.m_5776_() && (result = ProjectileUtil.m_37287_((Entity)player, (Vec3)(vec3 = player.m_146892_()), (Vec3)(vec32 = vec3.m_82549_(vec31 = player.m_20252_(1.0f).m_82490_(range))), (AABB)(aabb = player.m_20191_().m_82369_(vec31).m_82400_(1.0)), predicate = e -> e instanceof LivingEntity && !e.m_5833_(), (double)(sq = range * range))) != null && vec3.m_82557_(result.m_82450_()) < sq) {
            TARGET.updateTarget(result.m_82443_());
        }
    }

    @Nullable
    public static LivingEntity serverGetTarget(Player player) {
        if (player.f_19853_.m_5776_()) {
            return (LivingEntity)RayTraceUtil.TARGET.target;
        }
        UUID id = player.m_20148_();
        if (!TARGET_MAP.containsKey(id)) {
            return null;
        }
        UUID tid = ((ServerTarget)RayTraceUtil.TARGET_MAP.get((Object)id)).target;
        if (tid == null) {
            return null;
        }
        return (LivingEntity)((ServerLevel)player.f_19853_).m_8791_(tid);
    }

    public static class ServerTarget {
        public UUID target;
        public int time;

        public ServerTarget(UUID target) {
            this.target = target;
            this.time = 0;
        }
    }

    public static class EnderEntityTarget
    extends EntityTarget {
        private int timeout = 0;

        public EnderEntityTarget() {
            super(3.0, 0.08726646259971647, 10);
        }

        @Override
        public void onChange(@Nullable Entity entity) {
            UUID eid = entity == null ? null : entity.m_20148_();
            L2Library.PACKET_HANDLER.toServer(new TargetSetPacket(Proxy.getClientPlayer().m_20148_(), eid));
            this.timeout = 0;
        }

        @Override
        public void tickRender() {
            super.tickRender();
            if (this.target != null) {
                ++this.timeout;
                if (this.timeout > 100) {
                    this.onChange(this.target);
                }
            }
        }
    }
}

