/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.disenchant;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.disenchant.ContainerDisenchant;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.capabilities.block.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.FluidHelpers;
import com.lothrazar.cyclic.util.SoundUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileDisenchant
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 640000;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_BOOK = 1;
    ItemStackHandler inputSlots = new ItemStackHandler(2){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 1) {
                return stack.m_41720_() == Items.f_42517_;
            }
            if (slot == 0) {
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
                return enchants != null && enchants.size() > 0;
            }
            return stack.m_41720_() == Items.f_42690_;
        }
    };
    public static final int CAPACITY = 16000;
    ItemStackHandler outputSlots = new ItemStackHandler(2);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static ForgeConfigSpec.IntValue FLUIDCOST;
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    public FluidTankBase tank = new FluidTankBase(this, 16000, p -> FluidHelpers.matches(p.getFluid(), DataTags.EXPERIENCE));
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TileDisenchant(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.DISENCHANTER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileDisenchant e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileDisenchant e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        ItemStack input = this.inputSlots.getStackInSlot(0);
        if (input.m_41619_() || input.m_204117_(DataTags.DISENCHANTER_IMMUNE)) {
            return;
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if ((Integer)FLUIDCOST.get() > 0 && this.tank.getFluidAmount() < (Integer)FLUIDCOST.get()) {
            return;
        }
        ItemStack book = this.inputSlots.getStackInSlot(1);
        if (book.m_41720_() != Items.f_42517_ || !this.outputSlots.getStackInSlot(0).m_41619_() || !this.outputSlots.getStackInSlot(1).m_41619_() || input.m_41613_() != 1) {
            return;
        }
        LinkedHashMap outEnchants = Maps.newLinkedHashMap();
        Map inputEnchants = EnchantmentHelper.m_44831_((ItemStack)input);
        Enchantment keyMoved = null;
        Iterator iterator = inputEnchants.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            keyMoved = (Enchantment)entry.getKey();
            outEnchants.put(keyMoved, (Integer)entry.getValue());
        }
        if (outEnchants.size() == 0 || keyMoved == null) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.5) {
            SoundUtil.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11887_);
        } else {
            SoundUtil.playSound(this.f_58857_, this.f_58858_, SoundEvents.f_11671_);
        }
        this.energy.extractEnergy(cost, false);
        if ((Integer)FLUIDCOST.get() > 0) {
            this.tank.drain((Integer)FLUIDCOST.get(), IFluidHandler.FluidAction.EXECUTE);
        } else if ((Integer)FLUIDCOST.get() < 0) {
            Fluid newFluid = (Fluid)FluidXpJuiceHolder.STILL.get();
            if (!this.getFluid().isEmpty()) {
                newFluid = this.getFluid().getFluid();
            }
            this.tank.fill(new FluidStack(newFluid, -1 * (Integer)FLUIDCOST.get()), IFluidHandler.FluidAction.EXECUTE);
        }
        inputEnchants.remove(keyMoved);
        ItemStack eBook = new ItemStack((ItemLike)Items.f_42690_);
        EnchantmentHelper.m_44865_((Map)outEnchants, (ItemStack)eBook);
        this.inputSlots.extractItem(1, 1, false);
        this.outputSlots.insertItem(0, eBook, false);
        if (input.m_41720_() == Items.f_42690_ && inputEnchants.size() == 0) {
            this.inputSlots.extractItem(0, 64, false);
            this.inputSlots.insertItem(0, new ItemStack((ItemLike)Items.f_42517_), false);
        } else if (input.m_41720_() == Items.f_42690_) {
            ItemStack inputCopy = new ItemStack((ItemLike)Items.f_42690_);
            EnchantmentHelper.m_44865_((Map)inputEnchants, (ItemStack)inputCopy);
            this.inputSlots.extractItem(0, 64, false);
            this.inputSlots.insertItem(0, inputCopy, false);
        } else {
            EnchantmentHelper.m_44865_((Map)inputEnchants, (ItemStack)input);
        }
        input = this.inputSlots.getStackInSlot(0);
        inputEnchants = EnchantmentHelper.m_44831_((ItemStack)input);
        if (!input.m_41619_() && inputEnchants.size() == 0 && this.outputSlots.getStackInSlot(1).m_41619_()) {
            this.outputSlots.insertItem(1, input.m_41777_(), false);
            this.inputSlots.extractItem(0, 64, false);
        }
    }

    @Override
    public int getEnergy() {
        return this.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.DISENCHANTER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerDisenchant(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.fluidCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        if (cap == ForgeCapabilities.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    static enum Fields {
        REDSTONE,
        TIMER;

    }
}

