/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.util.ChatUtil;
import com.lothrazar.cyclic.util.PlayerUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShapeCard
extends ItemBaseCyclic {
    public static final String VALID_SHAPE = "cyclic-shape";

    public ShapeCard(Item.Properties properties) {
        super(properties);
    }

    public static void setBlockState(ItemStack wand, BlockState target) {
        CompoundTag encoded = NbtUtils.m_129202_((BlockState)target);
        wand.m_41784_().m_128365_("blockstate", (Tag)encoded);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        MutableComponent t;
        RelativeShape shape = RelativeShape.read(stack);
        if (shape != null) {
            t = Component.m_237115_((String)(this.m_5524_() + ".count"));
            t.m_130946_("" + shape.getCount());
            tooltip.add((Component)t);
            BlockState target = BuilderActionType.getBlockState(stack);
            String block = "scepter.cyclic.nothing";
            if (target != null) {
                block = target.m_60734_().m_7705_();
            }
            tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.AQUA + ChatUtil.lang(block))));
            if (flagIn.m_7050_()) {
                // empty if block
            }
        }
        t = Component.m_237115_((String)(this.m_5524_() + ".tooltip"));
        t.m_130940_(ChatFormatting.GRAY);
        tooltip.add((Component)t);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        RelativeShape shape = RelativeShape.read(stack);
        if (shape != null) {
            BlockState targetState = BuilderActionType.getBlockState(stack);
            if (targetState != null) {
                BlockPos centerPos = player.m_20183_();
                BlockPos posBuild = null;
                for (BlockPos s : shape.getShape()) {
                    posBuild = centerPos.m_121955_((Vec3i)s);
                    if (world.m_151570_(posBuild) || !world.m_46859_(posBuild)) continue;
                    int slot = -1;
                    if (!player.m_7500_() && (slot = PlayerUtil.getFirstSlotWithBlock(player, targetState)) < 0) {
                        ChatUtil.sendStatusMessage(player, "item.cyclic.shape_data.empty");
                        break;
                    }
                    if (!world.m_7731_(posBuild, targetState, 1)) continue;
                    PlayerUtil.decrStackSize(player, slot);
                }
            } else {
                ChatUtil.sendStatusMessage(player, "item.cyclic.shape_data.state");
            }
        } else {
            ChatUtil.sendStatusMessage(player, "item.cyclic.shape_data.nothing");
        }
        player.m_6674_(hand);
        return super.m_7203_(world, player, hand);
    }
}

