/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.item.slingshot.LaserItem;
import com.lothrazar.cyclic.net.PacketBaseCyclic;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkEvent;

public class PacketEntityLaser
extends PacketBaseCyclic {
    private int entityId;
    private boolean crosshair;

    public PacketEntityLaser(int eid, boolean cross) {
        this.entityId = eid;
        this.crosshair = cross;
    }

    public static void handle(PacketEntityLaser message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            IEnergyStorage storage;
            ItemStack stack;
            Level level;
            Entity target;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (PacketEntityLaser.canShoot(sender, target = (level = sender.f_19853_).m_6815_(message.entityId), stack = LaserItem.getIfHeld((Player)sender)) && (storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null)) != null) {
                float dmg;
                float f = dmg = message.crosshair ? 6.0f : 4.0f;
                if (target.m_6469_(DamageSource.m_19367_((Entity)sender, (Entity)sender), dmg)) {
                    LaserItem.resetStackDamageCool(stack, level.m_46467_());
                    storage.extractEnergy(50, false);
                }
            }
        });
        message.done(ctx);
    }

    private static boolean canShoot(ServerPlayer sender, Entity target, ItemStack stack) {
        if (!sender.m_6084_() || !target.m_6084_() || target.m_20147_()) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        return storage != null && storage.extractEnergy(50, true) == 50;
    }

    public static PacketEntityLaser decode(FriendlyByteBuf buf) {
        PacketEntityLaser msg = new PacketEntityLaser(buf.readInt(), buf.readBoolean());
        return msg;
    }

    public static void encode(PacketEntityLaser msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeBoolean(msg.crosshair);
    }
}

