/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.net.PacketBaseCyclic;
import com.lothrazar.cyclic.registry.ItemRegistry;
import java.util.function.Supplier;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketStorageBagScreen
extends PacketBaseCyclic {
    private ItemStack stack;
    private byte type;
    int slot;
    private StringTag nbtKey;
    private Tag nbtValue;

    public PacketStorageBagScreen() {
    }

    public PacketStorageBagScreen(ItemStack stack, int slot, byte type, StringTag nbtKey, Tag nbtValue) {
        this.stack = stack;
        this.slot = slot;
        this.type = type;
        this.nbtKey = nbtKey;
        this.nbtValue = nbtValue;
    }

    public static void handle(PacketStorageBagScreen message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                ItemStack serverStack = ItemStack.f_41583_;
                if (0 <= message.slot && message.slot < player.m_150109_().m_6643_()) {
                    serverStack = player.m_150109_().m_8020_(message.slot);
                }
                String key = message.nbtKey.m_7916_();
                if (!serverStack.m_41619_() && serverStack.m_41720_() == ItemRegistry.STORAGE_BAG.get() && (key.equals("refill_mode") || key.equals("deposit_mode") || key.equals("pickup_mode"))) {
                    serverStack.m_41784_().m_128365_(key, message.nbtValue);
                }
            }
        });
        message.done(context);
    }

    public static PacketStorageBagScreen decode(FriendlyByteBuf buffer) {
        PacketStorageBagScreen packet = new PacketStorageBagScreen();
        packet.slot = buffer.readInt();
        packet.type = buffer.readByte();
        packet.stack = buffer.m_130267_();
        packet.nbtKey = StringTag.m_129297_((String)buffer.m_130136_(Short.MAX_VALUE));
        switch (packet.type) {
            case 1: {
                packet.nbtValue = ByteTag.m_128266_((byte)buffer.readByte());
                break;
            }
            case 2: {
                packet.nbtValue = ShortTag.m_129258_((short)buffer.readShort());
                break;
            }
            case 3: {
                packet.nbtValue = IntTag.m_128679_((int)buffer.readInt());
                break;
            }
            case 4: {
                packet.nbtValue = LongTag.m_128882_((long)buffer.readLong());
                break;
            }
            case 5: {
                packet.nbtValue = FloatTag.m_128566_((float)buffer.readFloat());
                break;
            }
            case 6: {
                packet.nbtValue = DoubleTag.m_128500_((double)buffer.readDouble());
                break;
            }
            case 7: {
                packet.nbtValue = new ByteArrayTag(buffer.m_130052_());
                break;
            }
            case 8: {
                packet.nbtValue = StringTag.m_129297_((String)buffer.m_130136_(Short.MAX_VALUE));
                break;
            }
            case 9: {
                packet.nbtValue = new ListTag();
                break;
            }
            case 10: {
                packet.nbtValue = buffer.m_130260_();
                break;
            }
            case 11: {
                packet.nbtValue = new IntArrayTag(buffer.m_130100_());
                break;
            }
            case 12: {
                packet.nbtValue = new LongArrayTag(buffer.m_130105_(null));
                break;
            }
            default: {
                packet.nbtValue = StringTag.m_129297_((String)"");
            }
        }
        return packet;
    }

    public static void encode(PacketStorageBagScreen message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slot);
        buffer.writeByte((int)message.type);
        buffer.m_130055_(message.stack);
        buffer.m_130070_(message.nbtKey.m_7916_());
        switch (message.type) {
            case 1: {
                buffer.writeByte((int)((ByteTag)message.nbtValue).m_7063_());
                break;
            }
            case 2: {
                buffer.writeShort((int)((ShortTag)message.nbtValue).m_7053_());
                break;
            }
            case 3: {
                buffer.writeInt(((IntTag)message.nbtValue).m_7047_());
                break;
            }
            case 4: {
                buffer.writeLong(((LongTag)message.nbtValue).m_7046_());
                break;
            }
            case 5: {
                buffer.writeFloat(((FloatTag)message.nbtValue).m_7057_());
                break;
            }
            case 6: {
                buffer.writeDouble(((DoubleTag)message.nbtValue).m_7061_());
                break;
            }
            case 7: {
                buffer.m_130087_(((ByteArrayTag)message.nbtValue).m_128227_());
                break;
            }
            case 8: {
                buffer.m_130070_(((StringTag)message.nbtValue).m_7916_());
                break;
            }
            case 9: {
                buffer.m_130070_("There could have been a list here, if I knew how to process it.");
                break;
            }
            case 10: {
                buffer.m_130079_((CompoundTag)message.nbtValue);
                break;
            }
            case 11: {
                buffer.m_130089_(((IntArrayTag)message.nbtValue).m_128648_());
                break;
            }
            case 12: {
                buffer.m_130091_(((LongArrayTag)message.nbtValue).m_128851_());
                break;
            }
            default: {
                buffer.m_130070_("");
            }
        }
    }
}

