/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GrowthUtil {
    public static boolean isValidGrow(Level world, BlockPos current) {
        BonemealableBlock crop;
        if (world.m_46859_(current)) {
            return false;
        }
        BlockState bState = world.m_8055_(current);
        if (!bState.m_204336_(BlockTags.f_13073_) && !bState.m_204336_(BlockTags.f_13104_)) {
            ModCyclic.LOGGER.info("terra-grow can only grow minecraft:crops | minecraft:saplings : " + bState.m_60734_());
            return false;
        }
        Block block = bState.m_60734_();
        if (block instanceof BonemealableBlock && !(crop = (BonemealableBlock)block).m_7370_((BlockGetter)world, current, bState, world.f_46443_)) {
            ModCyclic.LOGGER.info("terra-grow canUseBonemeal is false  " + bState.m_60734_());
            return false;
        }
        return true;
    }

    public static boolean tryGrow(ServerLevel world, BlockPos current, double d) {
        if (!GrowthUtil.isValidGrow((Level)world, current)) {
            return false;
        }
        if (d >= 1.0 || world.f_46441_.m_188500_() < d) {
            BlockState bState = world.m_8055_(current);
            Block block = bState.m_60734_();
            if (world instanceof ServerLevel) {
                try {
                    GrowthUtil.grow(world, current, bState, block);
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    private static void grow(ServerLevel world, BlockPos current, BlockState bState, Block block) {
        Block block2 = bState.m_60734_();
        if (block2 instanceof BonemealableBlock) {
            BonemealableBlock crop = (BonemealableBlock)block2;
            crop.m_214148_(world, world.f_46441_, current, bState);
        } else {
            block.m_213898_(bState, world, current, world.f_46441_);
            block.m_213898_(bState, world, current, world.f_46441_);
            block.m_213898_(bState, world, current, world.f_46441_);
        }
        ModCyclic.LOGGER.info("terra-grow Successful growth" + block);
    }
}

