/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.config.ConfigSettings;
import carbonconfiglib.config.FileSystemWatcher;
import carbonconfiglib.gui.api.BackgroundTexture;
import carbonconfiglib.gui.api.BackgroundTypes;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.screen.ConfigScreen;
import carbonconfiglib.gui.screen.RequestScreen;
import carbonconfiglib.impl.PerWorldProxy;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.impl.entries.ColorValue;
import carbonconfiglib.impl.entries.RegistryKeyValue;
import carbonconfiglib.impl.entries.RegistryValue;
import carbonconfiglib.impl.internal.ConfigLogger;
import carbonconfiglib.impl.internal.EventHandler;
import carbonconfiglib.networking.CarbonNetwork;
import carbonconfiglib.utils.AutomationType;
import com.mojang.logging.LogUtils;
import java.util.function.BooleanSupplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.ModListScreen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.slf4j.Logger;

@Mod(value="carbonconfig")
public class CarbonConfig {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final FileSystemWatcher CONFIGS = new FileSystemWatcher(new ConfigLogger(LOGGER), FMLPaths.CONFIGDIR.get(), EventHandler.INSTANCE);
    public static final CarbonNetwork NETWORK = new CarbonNetwork();
    public static BooleanSupplier MOD_GUI = () -> false;
    ConfigHandler handler;
    public static ConfigEntry.BoolValue FORGE_SUPPORT;
    public static ConfigEntry.BoolValue FORCE_CUSTOM_BACKGROUND;
    public static ConfigEntry.EnumValue<BackgroundTypes> BACKGROUNDS;
    public static ConfigEntry.BoolValue INGAME_BACKGROUND;

    public CarbonConfig() {
        NETWORK.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonLoad);
        MinecraftForge.EVENT_BUS.addListener(this::load);
        MinecraftForge.EVENT_BUS.addListener(this::unload);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        if (FMLEnvironment.dist.isClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientLoad);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeys);
            MinecraftForge.EVENT_BUS.addListener(this::onKeyPressed);
            Config config = new Config("carbonconfig");
            ConfigSection section = config.add("general");
            FORGE_SUPPORT = (ConfigEntry.BoolValue)section.addBool("enable-forge-support", true, "Enables that CarbonConfig automatically adds Forge Configs into its own Config Gui System").setRequiredReload(ReloadMode.GAME);
            BACKGROUNDS = section.addEnum("custom-background", BackgroundTypes.PLANKS, BackgroundTypes.class, "Allows to pick for a Custom Background for Configs that use the default Background");
            FORCE_CUSTOM_BACKGROUND = section.addBool("force-custom-background", false, "Allows to force your Selected Background to be used everywhere instead of just default Backgrounds");
            INGAME_BACKGROUND = section.addBool("ingame-background", false, "Allows to set if the background is always visible or only if you are not in a active world");
            this.handler = CONFIGS.createConfig(config, ConfigSettings.withConfigType(ConfigType.CLIENT).withAutomations(AutomationType.AUTO_LOAD));
            this.handler.register();
        }
    }

    public static ConfigSettings getPerWorldProxy() {
        return PerWorldProxy.perWorld();
    }

    public ConfigSettings createLateLoadSettings() {
        return ConfigSettings.withSettings(AutomationType.AUTO_RELOAD, AutomationType.AUTO_SYNC);
    }

    public static ColorValue createColor(String key, int color, String ... comments) {
        return new ColorValue(key, color, comments);
    }

    public static <E> RegistryKeyValue.Builder<E> createRegistryKeyBuilder(String key, Class<E> clz) {
        return RegistryKeyValue.builder(key, clz);
    }

    public static <E> RegistryValue.Builder<E> createRegistryBuilder(String key, Class<E> clz) {
        return RegistryValue.builder(key, clz);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, String ... path) {
        CarbonConfig.openRemoteConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openRemoteConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            CarbonConfig.openLocalConfigFolder(config, texture, path);
            return;
        }
        if (config.getConfigType() == ConfigType.CLIENT) {
            LOGGER.info("Tried to open a local config in the Remote Opener");
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            LOGGER.info("Tried to open a Remote config when there was no remote attached");
            return;
        }
        if (!mc.m_91091_() && !mc.f_91074_.m_20310_(4)) {
            LOGGER.info("Tried to open a Remote config without permission");
            return;
        }
        mc.m_91152_((Screen)new RequestScreen(texture.asHolder(), ConfigScreen.Navigator.create(config).withWalker(path), mc.f_91080_, config));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, String ... path) {
        CarbonConfig.openLocalConfigFolder(config, BackgroundTexture.DEFAULT, path);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openLocalConfigFolder(IModConfig config, BackgroundTexture texture, String ... path) {
        if (!config.isLocalConfig()) {
            LOGGER.info("Tried to open a Remote config in the Local Opener");
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new ConfigScreen(ConfigScreen.Navigator.create(config).withWalker(path), config, mc.f_91080_, texture.asHolder()));
    }

    public static boolean hasPermission(Player player, int permissionLevel) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_129792_() && server.m_7779_(player.m_36316_())) {
            return true;
        }
        return player.m_20310_(permissionLevel);
    }

    public void onCommonLoad(FMLCommonSetupEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.createDefaultConfig();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientLoad(FMLClientSetupEvent event) {
        EventHandler.INSTANCE.onConfigsLoaded();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeys(RegisterKeyMappingsEvent event) {
        KeyMapping mapping = new KeyMapping("key.carbon_config.key", 335, "key.carbon_config");
        event.register(mapping);
        MOD_GUI = () -> ((KeyMapping)mapping).m_90857_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onKeyPressed(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && event.getAction() == 1 && MOD_GUI.getAsBoolean()) {
            mc.m_91152_((Screen)new ModListScreen(mc.f_91080_));
        }
    }

    public void load(ServerAboutToStartEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.load();
        }
    }

    public void unload(ServerStoppingEvent event) {
        for (ConfigHandler handler : CONFIGS.getAllConfigs()) {
            if (!PerWorldProxy.isProxy(handler.getProxy())) continue;
            handler.unload();
        }
    }
}

