/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.impl.forge.ForgeArray;
import carbonconfiglib.gui.impl.forge.ForgeDataType;
import carbonconfiglib.gui.impl.forge.ForgeValue;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.structure.IStructuredData;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.util.Strings;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.objects.utils.ObjectLists;

public class ForgeLeaf
implements IConfigNode {
    ForgeConfigSpec.ConfigValue<?> data;
    CommentedConfig config;
    ForgeConfigSpec.ValueSpec spec;
    ForgeDataType<?> type;
    boolean isArray;
    ForgeValue value;
    ForgeArray array;
    Component tooltip;

    public ForgeLeaf(ForgeConfigSpec spec, ForgeConfigSpec.ConfigValue<?> data, CommentedConfig config) {
        this.data = data;
        this.config = config;
        this.spec = this.getSpec(spec, data);
        String[] array = this.buildComment(spec);
        if (array != null && array.length > 0) {
            MutableComponent comp = Component.m_237119_();
            int i = 0;
            while (i < array.length) {
                comp.m_130946_("\n").m_130946_(array[i++]).m_130940_(ChatFormatting.GRAY);
            }
            this.tooltip = comp;
        }
        this.guessDataType();
    }

    private void guessDataType() {
        Class<?> clz = this.spec.getClazz();
        if (clz == Object.class) {
            clz = this.spec.getDefault().getClass();
        }
        this.type = ForgeDataType.getDataByType(clz);
        if (this.type == null && clz != null && List.class.isAssignableFrom(clz)) {
            this.isArray = true;
            this.type = ForgeDataType.STRING;
        }
    }

    public boolean isValid() {
        return this.type != null;
    }

    @Override
    public List<IConfigNode> getChildren() {
        return null;
    }

    @Override
    public INode asNode() {
        if (this.isArray) {
            if (this.array == null) {
                this.array = new ForgeArray(this.getName(), this.getTooltip(), this.spec.needsWorldRestart() ? ReloadMode.WORLD : null, this.type.getDataType(), this.getCurrent(), this.getDefault(), () -> ObjectLists.empty(), this.type::parse, this::save);
            }
            return this.array;
        }
        if (this.value == null) {
            this.value = new ForgeValue(this.getName(), this.getTooltip(), this.spec.needsWorldRestart() ? ReloadMode.WORLD : null, this.type.getDataType(), this.getCurrent(this.type), this.getDefault(this.type), this::getSuggestions, this.type::parse, this::save);
        }
        return this.value;
    }

    private List<String> getDefault() {
        return new ObjectArrayList((Collection)((List)this.spec.getDefault()));
    }

    private List<String> getCurrent() {
        return new ObjectArrayList((Collection)((List)this.config.get(this.data.getPath())));
    }

    private <T> String getDefault(ForgeDataType<T> type) {
        return type.serialize(this.spec.getDefault());
    }

    private <T> String getCurrent(ForgeDataType<T> type) {
        return type.isEnum() && String.class.equals(this.config.get(this.data.getPath()).getClass()) ? (String)this.config.get(this.data.getPath()) : type.serialize(this.config.get(this.data.getPath()));
    }

    private List<ISuggestionProvider.Suggestion> getSuggestions() {
        return this.type instanceof ForgeDataType.EnumDataType ? ((ForgeDataType.EnumDataType)this.type).getSuggestions(this.spec) : ObjectLists.empty();
    }

    private void save(String value) {
        this.config.set(this.data.getPath(), this.type.parse(value).getValue());
    }

    private void save(List<String> values) {
        this.config.set(this.data.getPath(), values);
    }

    @Override
    public IStructuredData.StructureType getDataStructure() {
        return this.isArray ? IStructuredData.StructureType.LIST : IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public boolean isChanged() {
        if (this.value != null && this.value.isChanged()) {
            return true;
        }
        return this.array != null && this.array.isChanged();
    }

    @Override
    public void save() {
        if (this.value != null) {
            this.value.save();
        }
        if (this.array != null) {
            this.array.save();
        }
    }

    @Override
    public void setPrevious() {
        if (this.value != null) {
            this.value.setPrevious();
        }
        if (this.array != null) {
            this.array.setPrevious();
        }
    }

    @Override
    public void setDefault() {
        this.asNode();
        if (this.isArray) {
            this.array.setDefault();
        } else {
            this.value.setDefault();
        }
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public boolean requiresReload() {
        return this.spec.needsWorldRestart();
    }

    @Override
    public String getNodeName() {
        return null;
    }

    @Override
    public Component getName() {
        return IConfigNode.createLabel((String)Iterables.getLast((Iterable)this.data.getPath(), (Object)""));
    }

    @Override
    public Component getTooltip() {
        String limit;
        MutableComponent comp = Component.m_237119_();
        comp.m_7220_((Component)Component.m_237113_((String)((String)Iterables.getLast((Iterable)this.data.getPath(), (Object)""))).m_130940_(ChatFormatting.YELLOW));
        if (this.tooltip != null) {
            comp.m_7220_(this.tooltip);
        }
        if ((limit = this.type.getLimitations(this.spec)) != null && !Strings.isBlank((String)limit)) {
            comp.m_130946_("\n").m_7220_((Component)Component.m_237113_((String)limit).m_130940_(ChatFormatting.BLUE));
        }
        return comp;
    }

    private String[] buildComment(ForgeConfigSpec spec) {
        String value = this.spec.getComment();
        if (value == null) {
            return null;
        }
        int cutoffPoint = this.getSmallerOfPresent(value.indexOf("Range: "), value.indexOf("Allowed Values: "));
        return (cutoffPoint >= 0 ? value.substring(0, cutoffPoint) : value).split("\n");
    }

    private ForgeConfigSpec.ValueSpec getSpec(ForgeConfigSpec spec, ForgeConfigSpec.ConfigValue<?> value) {
        return (ForgeConfigSpec.ValueSpec)spec.get(value.getPath());
    }

    private int getSmallerOfPresent(int first, int second) {
        if (first == -1 || second != -1 && first > second) {
            return second;
        }
        return first;
    }
}

