/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.impl.forge;

import carbonconfiglib.api.ISuggestionProvider;
import carbonconfiglib.gui.api.DataType;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.impl.ReloadMode;
import carbonconfiglib.utils.ParseResult;
import carbonconfiglib.utils.structure.IStructuredData;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import speiger.src.collections.objects.lists.ObjectArrayList;
import speiger.src.collections.utils.Stack;

public class ForgeValue
implements IValueNode {
    Component name;
    Component tooltip;
    DataType type;
    ReloadMode mode;
    Function<String, ParseResult<?>> isValid;
    Supplier<List<ISuggestionProvider.Suggestion>> suggestions;
    Consumer<String> saved;
    Stack<String> previous = new ObjectArrayList();
    String current;
    String defaultValue;

    public ForgeValue(Component name, Component tooltip, ReloadMode mode, DataType type, String value, String defaultValue, Supplier<List<ISuggestionProvider.Suggestion>> suggestions, Function<String, ParseResult<?>> isValid, Consumer<String> saved) {
        this.name = name;
        this.tooltip = tooltip;
        this.isValid = isValid;
        this.mode = mode;
        this.type = type;
        this.current = value;
        this.previous.push((Object)this.current);
        this.defaultValue = defaultValue;
        this.suggestions = suggestions;
        this.saved = saved;
    }

    public void save() {
        this.saved.accept(this.current);
    }

    @Override
    public boolean isDefault() {
        return Objects.equals(this.defaultValue, this.current);
    }

    @Override
    public boolean isChanged() {
        return !Objects.equals(this.previous.top(), this.current);
    }

    @Override
    public void setDefault() {
        this.current = this.defaultValue;
    }

    @Override
    public void setPrevious() {
        this.current = (String)this.previous.top();
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public void createTemp() {
        this.previous.push((Object)this.current);
    }

    @Override
    public void apply() {
        if (this.previous.size() > 1) {
            this.previous.pop();
        }
    }

    @Override
    public IStructuredData.StructureType getNodeType() {
        return IStructuredData.StructureType.SIMPLE;
    }

    @Override
    public boolean requiresRestart() {
        return this.mode == ReloadMode.GAME;
    }

    @Override
    public boolean requiresReload() {
        return this.mode == ReloadMode.WORLD;
    }

    @Override
    public Component getName() {
        return this.name;
    }

    @Override
    public Component getTooltip() {
        return this.tooltip;
    }

    @Override
    public String get() {
        return this.current;
    }

    @Override
    public void set(String value) {
        this.current = value;
    }

    @Override
    public ParseResult<Boolean> isValid(String value) {
        return ParseResult.success(this.isValid.apply(value).isValid());
    }

    @Override
    public DataType getDataType() {
        return this.type;
    }

    @Override
    public boolean isForcingSuggestions() {
        return this.type == DataType.ENUM;
    }

    @Override
    public List<ISuggestionProvider.Suggestion> getSuggestions() {
        return this.suggestions.get();
    }
}

