/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking;

import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.networking.carbon.ConfigRequestPacket;
import carbonconfiglib.networking.carbon.SaveConfigPacket;
import carbonconfiglib.networking.carbon.StateSyncPacket;
import carbonconfiglib.networking.forge.RequestConfigPacket;
import carbonconfiglib.networking.forge.SaveForgeConfigPacket;
import carbonconfiglib.networking.minecraft.RequestGameRulesPacket;
import carbonconfiglib.networking.minecraft.SaveGameRulesPacket;
import carbonconfiglib.networking.snyc.BulkSyncPacket;
import carbonconfiglib.networking.snyc.SyncPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import speiger.src.collections.objects.sets.ObjectOpenHashSet;

public class CarbonNetwork {
    public static final String VERSION = "1.0.0";
    SimpleChannel channel;
    Set<UUID> clientInstalledPlayers = new ObjectOpenHashSet();
    boolean serverInstalled = false;

    public void init() {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("carbonconfig", "networking"), () -> VERSION, this::acceptsConnection, this::acceptsConnection);
        this.registerPacket(0, SyncPacket.class, SyncPacket::new);
        this.registerPacket(1, BulkSyncPacket.class, BulkSyncPacket::new);
        this.registerPacket(2, ConfigRequestPacket.class, ConfigRequestPacket::new);
        this.registerPacket(3, ConfigAnswerPacket.class, ConfigAnswerPacket::new);
        this.registerPacket(4, SaveConfigPacket.class, SaveConfigPacket::new);
        this.registerPacket(5, RequestConfigPacket.class, RequestConfigPacket::new);
        this.registerPacket(6, SaveForgeConfigPacket.class, SaveForgeConfigPacket::new);
        this.registerPacket(7, RequestGameRulesPacket.class, RequestGameRulesPacket::new);
        this.registerPacket(8, SaveGameRulesPacket.class, SaveGameRulesPacket::new);
        this.registerPacket(255, StateSyncPacket.class, StateSyncPacket::new);
    }

    private boolean acceptsConnection(String version) {
        return VERSION.equals(version) || NetworkRegistry.ACCEPTVANILLA.equals(version) || NetworkRegistry.ABSENT.equals(version);
    }

    private <T extends ICarbonPacket> void registerPacket(int index, Class<T> packet, Supplier<T> creator) {
        this.channel.registerMessage(index, packet, this::writePacket, K -> this.readPacket((FriendlyByteBuf)K, creator), this::handlePacket);
    }

    protected void writePacket(ICarbonPacket packet, FriendlyByteBuf buffer) {
        try {
            packet.write(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected <T extends ICarbonPacket> T readPacket(FriendlyByteBuf buffer, Supplier<T> values) {
        try {
            ICarbonPacket packet = (ICarbonPacket)values.get();
            packet.read(buffer);
            return (T)packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void handlePacket(ICarbonPacket packet, Supplier<NetworkEvent.Context> provider) {
        try {
            NetworkEvent.Context context = provider.get();
            Player player = this.getPlayer(context);
            context.enqueueWork(() -> packet.process(player));
            context.setPacketHandled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isInWorld() {
        return this.getClientPlayer() != null;
    }

    protected Player getPlayer(NetworkEvent.Context cont) {
        ServerPlayer entity = cont.getSender();
        return entity != null ? entity : this.getClientPlayer();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected Player getClientPlayer() {
        Minecraft mc = Minecraft.m_91087_();
        return mc == null ? null : mc.f_91074_;
    }

    public void sendToServer(ICarbonPacket packet) {
        this.channel.send(PacketDistributor.SERVER.noArg(), (Object)packet);
    }

    public void sendToAllPlayers(ICarbonPacket packet) {
        this.channel.send(PacketDistributor.NMLIST.with(this::getAllPlayers), (Object)packet);
    }

    public void onPlayerJoined(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.add(player.m_20148_());
        } else {
            this.serverInstalled = true;
        }
    }

    public void onPlayerLeft(Player player, boolean server) {
        if (server) {
            this.clientInstalledPlayers.remove(player.m_20148_());
        } else {
            this.serverInstalled = false;
        }
    }

    private List<Connection> getAllPlayers() {
        ObjectArrayList players = new ObjectArrayList();
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            if (!this.isInstalledOnClient(player)) continue;
            players.add(player.f_8906_.m_6198_());
        }
        return players;
    }

    public boolean isInstalled(Player player) {
        return player instanceof ServerPlayer ? this.isInstalledOnClient((ServerPlayer)player) : this.isInstalledOnServer();
    }

    public boolean isInstalledOnClient(ServerPlayer player) {
        return this.clientInstalledPlayers.contains(player.m_20148_());
    }

    public boolean isInstalledOnServer() {
        return this.serverInstalled;
    }

    public void sendToPlayer(ICarbonPacket packet, Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new RuntimeException("Sending a Packet to a Player from client is not allowed");
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)packet);
    }
}

