/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import carbonconfiglib.utils.MultilinePolicy;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class ConfigRequestPacket
implements ICarbonPacket {
    UUID id;
    String identifier;

    public ConfigRequestPacket() {
    }

    public ConfigRequestPacket(UUID id, String identifier) {
        this.id = id;
        this.identifier = identifier;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.id);
        buffer.m_130072_(this.identifier, Short.MAX_VALUE);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.id = buffer.m_130259_();
        this.identifier = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ConfigHandler handler = CarbonConfig.CONFIGS.getConfig(this.identifier);
        if (handler == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130072_(handler.getConfig().serialize(MultilinePolicy.DISABLED), 262144);
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.id, data), player);
    }
}

