/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketDestructionGUI {
    private final int left;
    private final int right;
    private final int up;
    private final int down;
    private final int depth;

    public PacketDestructionGUI(int l, int r, int u, int d, int dep) {
        this.left = l;
        this.right = r;
        this.up = u;
        this.down = d;
        this.depth = dep;
    }

    public static void encode(PacketDestructionGUI msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.left);
        buffer.writeInt(msg.right);
        buffer.writeInt(msg.up);
        buffer.writeInt(msg.down);
        buffer.writeInt(msg.depth);
    }

    public static PacketDestructionGUI decode(FriendlyByteBuf buffer) {
        return new PacketDestructionGUI(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static class Handler {
        public static void handle(PacketDestructionGUI msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ItemStack heldItem = GadgetDestruction.getGadget((Player)((NetworkEvent.Context)ctx.get()).getSender());
                if (heldItem.m_41619_()) {
                    return;
                }
                GadgetDestruction.setToolValue(heldItem, msg.left, "left");
                GadgetDestruction.setToolValue(heldItem, msg.right, "right");
                GadgetDestruction.setToolValue(heldItem, msg.up, "up");
                GadgetDestruction.setToolValue(heldItem, msg.down, "down");
                GadgetDestruction.setToolValue(heldItem, msg.depth, "depth");
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

