/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;

public final class Region
implements Serializable {
    private static final Region ZERO = new Region((Vec3i)BlockPos.f_121853_);
    private static final long serialVersionUID = 8391481277782374853L;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;

    public static Region singleZero() {
        return ZERO;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder enclosingBuilder() {
        return Region.enclosingBuilder(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static Builder enclosingBuilder(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new Builder(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static Region deserializeFrom(CompoundTag tag) {
        return new Region(tag.m_128451_("minX"), tag.m_128451_("minY"), tag.m_128451_("minZ"), tag.m_128451_("maxX"), tag.m_128451_("maxY"), tag.m_128451_("maxZ"));
    }

    public Region(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public Region(Vec3i vertex) {
        this(vertex, vertex);
    }

    public Region(Vec3i min, Vec3i max) {
        this(min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_());
    }

    public Region translate(int x, int y, int z) {
        return new Region(this.minX + x, this.minY + y, this.minZ + z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region translate(Vec3i direction) {
        return this.translate(direction.m_123341_(), direction.m_123342_(), direction.m_123343_());
    }

    public Region inverseTranslate(Vec3i direction) {
        return this.translate(-direction.m_123341_(), -direction.m_123342_(), -direction.m_123343_());
    }

    public Region grow(int x, int y, int z) {
        return new Region(this.minX, this.minY, this.minZ, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region grow(int size) {
        return this.grow(size, size, size);
    }

    public Region shrink(int x, int y, int z) {
        return this.grow(-x, -y, -z);
    }

    public Region shrink(int size) {
        return this.grow(-size);
    }

    public Region expand(int x, int y, int z) {
        return new Region(this.minX - x, this.minY - y, this.minZ - z, this.maxX + x, this.maxY + y, this.maxZ + z);
    }

    public Region expand(Vec3i vec) {
        return this.expand(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public Region expand(int size) {
        return this.expand(size, size, size);
    }

    public Region collapse(int x, int y, int z) {
        return this.expand(-x, -y, -z);
    }

    public Region collapse(Vec3i vec) {
        return this.collapse(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public Region collapse(int size) {
        return this.expand(-size);
    }

    public Region intersect(Region other) {
        int minX = Math.max(this.minX, other.minX);
        int minY = Math.max(this.minY, other.minY);
        int minZ = Math.max(this.minZ, other.minZ);
        int maxX = Math.min(this.maxX, other.maxX);
        int maxY = Math.min(this.maxY, other.maxY);
        int maxZ = Math.min(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public Region union(Region other) {
        int minX = Math.min(this.minX, other.minX);
        int minY = Math.min(this.minY, other.minY);
        int minZ = Math.min(this.minZ, other.minZ);
        int maxX = Math.max(this.maxX, other.maxX);
        int maxY = Math.max(this.maxY, other.maxY);
        int maxZ = Math.max(this.maxZ, other.maxZ);
        return new Region(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public int getXSize() {
        return Math.abs(this.maxX - this.minX) + 1;
    }

    public int getYSize() {
        return Math.abs(this.maxY - this.minY) + 1;
    }

    public int getZSize() {
        return Math.abs(this.maxZ - this.minZ) + 1;
    }

    public int size() {
        return this.getXSize() * this.getYSize() * this.getZSize();
    }

    public boolean containsX(int x) {
        return x >= this.minX && x <= this.maxX;
    }

    public boolean containsY(int y) {
        return y >= this.minY && y <= this.maxY;
    }

    public boolean containsZ(int z) {
        return z >= this.minZ && z <= this.maxZ;
    }

    public boolean mayContain(int x, int y, int z) {
        return this.contains(x, y, z);
    }

    public boolean contains(int x, int y, int z) {
        return this.containsX(x) && this.containsY(y) && this.containsZ(z);
    }

    public boolean contains(Vec3i vec) {
        return this.mayContain(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public boolean intersectsWith(Region other) {
        return this.maxX >= other.minX && this.minX <= other.maxX && this.maxZ >= other.minZ && this.minZ <= other.maxZ && this.maxY >= other.minY && this.minY <= other.maxY;
    }

    public Stream<BlockPos> stream() {
        return BlockPos.m_121886_((int)this.minX, (int)this.minY, (int)this.minZ, (int)this.maxX, (int)this.maxY, (int)this.maxZ).map(BlockPos::m_7949_);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minX", this.minX).add("minY", this.minY).add("minZ", this.minZ).add("maxX", this.maxX).add("maxY", this.maxY).add("maxZ", this.maxZ).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region region = (Region)o;
        return this.minX == region.minX && this.minY == region.minY && this.minZ == region.minZ && this.maxX == region.maxX && this.maxY == region.maxY && this.maxZ == region.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public ImmutableSortedSet<ChunkPos> getUnloadedChunks(LevelReader reader) {
        ImmutableSortedSet.Builder posBuilder = ImmutableSortedSet.orderedBy(Comparator.comparing(ChunkPos::m_45604_).thenComparing(ChunkPos::m_45605_));
        for (int i = this.minX; i <= this.maxX; i += 16) {
            for (int j = this.minZ; j <= this.maxZ; j += 16) {
                if (reader.m_7232_(i >> 4, j >> 4)) continue;
                posBuilder.add((Object)new ChunkPos(i >> 4, j >> 4));
            }
        }
        for (int j = this.minZ; j <= this.maxZ; j += 16) {
            if (reader.m_7232_(this.maxX >> 4, j >> 4)) continue;
            posBuilder.add((Object)new ChunkPos(this.maxX >> 4, j >> 4));
        }
        if (!reader.m_7232_(this.maxX >> 4, this.maxZ >> 4)) {
            posBuilder.add((Object)new ChunkPos(this.maxX >> 4, this.maxZ >> 4));
        }
        return posBuilder.build();
    }

    public CompoundTag serialize() {
        return this.serializeTo(new CompoundTag());
    }

    public CompoundTag serializeTo(CompoundTag tag) {
        tag.m_128405_("minX", this.minX);
        tag.m_128405_("minY", this.minY);
        tag.m_128405_("minZ", this.minZ);
        tag.m_128405_("maxX", this.maxX);
        tag.m_128405_("maxY", this.maxY);
        tag.m_128405_("maxZ", this.maxZ);
        return tag;
    }

    public static class Builder {
        private int minX;
        private int minY;
        private int minZ;
        private int maxX;
        private int maxY;
        private int maxZ;

        private Builder() {
            this(0, 0, 0, 0, 0, 0);
        }

        public Builder(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public Builder encloseAll(Iterable<? extends Vec3i> iterable) {
            for (Vec3i vec3i : iterable) {
                this.enclose(vec3i);
            }
            return this;
        }

        public Builder enclose(Region region) {
            this.enclose((Vec3i)region.getMin());
            this.enclose((Vec3i)region.getMax());
            return this;
        }

        public Builder enclose(Vec3i vec) {
            return this.enclose(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
        }

        public Builder enclose(int x, int y, int z) {
            this.encloseX(x);
            this.encloseY(y);
            this.encloseZ(z);
            return this;
        }

        public Builder encloseX(int x) {
            this.minX = Math.min(x, this.minX);
            this.maxX = Math.max(x, this.maxX);
            return this;
        }

        public Builder encloseY(int y) {
            this.minY = Math.min(y, this.minY);
            this.maxY = Math.max(y, this.maxY);
            return this;
        }

        public Builder encloseZ(int z) {
            this.minZ = Math.min(z, this.minZ);
            this.maxZ = Math.max(z, this.maxZ);
            return this;
        }

        public Region build() {
            return new Region(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }
}

