/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.view;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

@Immutable
public final class BuildContext {
    @Nonnull
    private final LevelAccessor world;
    @Nullable
    private final Player player;
    private final ItemStack stack;

    public static Builder builder() {
        return new Builder();
    }

    public BuildContext(@Nonnull LevelAccessor world, @Nullable Player player, @Nonnull ItemStack stack) {
        this.world = world;
        this.player = player;
        this.stack = stack;
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ServerLevel getServerWorld() {
        return ((ServerLevelAccessor)this.world).m_6018_();
    }

    public static final class Builder {
        @Nullable
        private LevelAccessor world = null;
        @Nullable
        private Player buildingPlayer = null;
        @Nonnull
        private ItemStack stack = ItemStack.f_41583_;

        private Builder() {
        }

        public Builder world(@Nonnull LevelAccessor world) {
            this.world = world;
            return this;
        }

        public Builder player(@Nullable Player buildingPlayer) {
            this.buildingPlayer = buildingPlayer;
            if (this.world == null && buildingPlayer != null) {
                this.world = buildingPlayer.f_19853_;
            }
            return this;
        }

        public Builder stack(@Nonnull ItemStack stack) {
            this.stack = stack;
            return this;
        }

        public BuildContext build() {
            return this.build(null);
        }

        public BuildContext build(@Nullable LevelAccessor world) {
            return new BuildContext(world != null ? world : Objects.requireNonNull(this.world), this.buildingPlayer, this.stack);
        }
    }
}

