/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.network;

import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.dimension.MissingDimensionException;
import dev.compactmods.machines.location.LevelBlockPosition;
import dev.compactmods.machines.util.PlayerUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.NetworkEvent;

public record PlayerRequestedTeleportPacket(LevelBlockPosition machine, ChunkPos room) {
    public PlayerRequestedTeleportPacket(FriendlyByteBuf buf) {
        this((LevelBlockPosition)buf.m_130057_(LevelBlockPosition.CODEC), buf.m_178383_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130059_(LevelBlockPosition.CODEC, (Object)this.machine);
        buf.m_178341_(this.room);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            try {
                PlayerUtil.teleportPlayerIntoMachine(player.f_19853_, (Player)player, this.machine.getBlockPosition());
            }
            catch (MissingDimensionException e) {
                CompactMachines.LOGGER.error("Failed to teleport player into machine.", (Throwable)e);
            }
        });
        return true;
    }
}

