/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.content.contraptions.components.sifter;

import com.google.gson.JsonObject;
import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.content.contraptions.components.meshes.AdvancedBaseMesh;
import com.oierbravo.createsifter.content.contraptions.components.meshes.BaseMesh;
import com.oierbravo.createsifter.content.contraptions.components.meshes.IMesh;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SifterBlockEntity;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SifterConfig;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipeSerializer;
import com.oierbravo.createsifter.foundation.data.recipe.SiftingRecipeBuilder;
import com.simibubi.create.content.kinetics.crusher.AbstractCrushingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class SiftingRecipe
extends AbstractCrushingRecipe {
    public NonNullList<ProcessingOutput> results;
    ItemStack meshStack;
    ItemStack siftableIngredienStack;
    private boolean waterlogged;
    private float minimumSpeed;
    private boolean advanced;

    public SiftingRecipeSerializer getSerializer() {
        return (SiftingRecipeSerializer)ModRecipeTypes.SIFTING.getSerializer();
    }

    public SiftingRecipe(SiftingRecipeBuilder.SiftingRecipeParams params) {
        super((IRecipeTypeInfo)ModRecipeTypes.SIFTING, (ProcessingRecipeBuilder.ProcessingRecipeParams)params);
        this.processingDuration = params.processingDuration;
        this.ingredients = params.ingredients;
        this.results = params.results;
        this.id = params.id;
        this.meshStack = this.getMeshItemStack();
        this.advanced = this.isAdvancedMesh(this.meshStack);
        this.siftableIngredienStack = this.getSiftableItemStack();
        this.waterlogged = params.waterlogged;
        this.minimumSpeed = params.minimumSpeed;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn, boolean waterlogged, float speed, boolean advanced) {
        if (inv.m_7983_()) {
            return false;
        }
        if (this.isWaterlogged() != waterlogged) {
            return false;
        }
        if (this.hasSpeedRequeriment() && speed < this.minimumSpeed) {
            return false;
        }
        if (advanced && this.meshStack.m_41720_() instanceof BaseMesh) {
            return false;
        }
        return this.getSiftableIngredient().test(inv.m_8020_(0)) && this.getMeshIngredient().test(inv.m_8020_(1));
    }

    public ItemStack getMeshItemStack() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (!SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getSiftableItemStack() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public Ingredient getSiftableIngredient() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return (Ingredient)this.ingredients.get(i);
        }
        return Ingredient.f_43901_;
    }

    public Ingredient getMeshIngredient() {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack itemStack = ((Ingredient)this.ingredients.get(i)).m_43908_()[0];
            if (!SiftingRecipe.isMeshItemStack(itemStack)) continue;
            return (Ingredient)this.ingredients.get(i);
        }
        return Ingredient.f_43901_;
    }

    public static boolean isMeshItemStack(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof IMesh;
    }

    private boolean isAdvancedMesh(ItemStack meshStack) {
        return this.meshStack.m_41720_() instanceof AdvancedBaseMesh;
    }

    public boolean requiresAdvancedMesh() {
        return this.advanced;
    }

    public String toString() {
        return "createsifter:sifting";
    }

    protected int getMaxInputCount() {
        return 4;
    }

    protected int getMaxOutputCount() {
        return (Integer)SifterConfig.SIFTER_OUTPUT_CAPACITY.get();
    }

    public static boolean canHandSift(Level world, ItemStack stack, ItemStack mesh, boolean waterlogged) {
        return SiftingRecipe.getMatchingInHandRecipes(world, stack, mesh, waterlogged, 0.0f);
    }

    public static List<ItemStack> applyHandSift(Level world, Vec3 position, ItemStack stack, ItemStack mesh, boolean waterlogged) {
        SifterInv inventoryIn = new SifterInv(stack, mesh);
        Optional<SiftingRecipe> recipe = ModRecipeTypes.SIFTING.find((Container)inventoryIn, world, waterlogged, 0.0f);
        if (recipe.isPresent()) {
            return recipe.get().rollResults();
        }
        return Collections.singletonList(stack);
    }

    public List<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public List<ItemStack> rollResults(List<ProcessingOutput> rollableResults) {
        return super.rollResults(rollableResults);
    }

    public List<ItemStack> rollResults() {
        return this.rollResults(this.getRollableResults());
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.waterlogged = GsonHelper.m_13855_((JsonObject)json, (String)"waterlogged", (boolean)false);
        this.minimumSpeed = GsonHelper.m_13820_((JsonObject)json, (String)"minimumSpeed", (float)1.0f);
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        if (this.waterlogged) {
            json.addProperty("waterlogged", Boolean.valueOf(this.waterlogged));
        }
        if (this.hasSpeedRequeriment()) {
            json.addProperty("minimumSpeed", (Number)Float.valueOf(this.minimumSpeed));
        }
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.waterlogged = buffer.readBoolean();
        this.minimumSpeed = buffer.readFloat();
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.writeBoolean(this.waterlogged);
        buffer.writeFloat(this.minimumSpeed);
    }

    public boolean isWaterlogged() {
        return this.waterlogged;
    }

    public boolean hasSpeedRequeriment() {
        return this.minimumSpeed > SifterBlockEntity.DEFAULT_MINIMUM_SPEED;
    }

    public float getSpeedRequeriment() {
        return this.minimumSpeed;
    }

    public static boolean getMatchingInHandRecipes(Level world, ItemStack stack, ItemStack mesh, boolean waterlogged, float speed) {
        return ModRecipeTypes.SIFTING.find((Container)new SifterInv(stack, mesh), world, waterlogged, speed).isPresent();
    }

    public boolean matches(RecipeWrapper pContainer, Level pLevel) {
        return this.matches(pContainer, pLevel, false, 0.0f, false);
    }

    public float getMinimumSpeed() {
        return this.minimumSpeed;
    }

    public static class SifterInv
    extends RecipeWrapper {
        public SifterInv(ItemStack stack, ItemStack mesh) {
            super((IItemHandlerModifiable)new ItemStackHandler(2));
            this.inv.setStackInSlot(0, stack);
            this.inv.setStackInSlot(1, mesh);
        }
    }
}

