/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.core.attributeslib.asm;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import shadows.apotheosis.core.attributeslib.api.ALAttributes;

public class ALCombatRules {
    public static float getDamageAfterProtection(LivingEntity target, DamageSource src, float amount, float protPoints) {
        Entity entity = src.m_7639_();
        if (entity instanceof LivingEntity) {
            float pierce;
            LivingEntity attacker = (LivingEntity)entity;
            float shred = (float)attacker.m_21133_((Attribute)ALAttributes.PROT_SHRED.get());
            if (shred > 0.001f) {
                protPoints *= 1.0f - shred;
            }
            if ((pierce = (float)attacker.m_21133_((Attribute)ALAttributes.PROT_PIERCE.get())) > 0.001f) {
                protPoints -= pierce;
            }
        }
        if (protPoints <= 0.0f) {
            return amount;
        }
        return amount * ALCombatRules.getProtDamageReduction(protPoints);
    }

    public static float getProtDamageReduction(float protPoints) {
        return 1.0f - Math.min(0.025f * protPoints, 0.85f);
    }

    public static float getDamageAfterArmor(LivingEntity target, DamageSource src, float amount, float armor, float toughness) {
        Entity entity = src.m_7639_();
        if (entity instanceof LivingEntity) {
            float pierce;
            LivingEntity attacker = (LivingEntity)entity;
            float shred = (float)attacker.m_21133_((Attribute)ALAttributes.ARMOR_SHRED.get());
            float bypassResist = Math.min(toughness * 0.02f, 0.6f);
            if (shred > 0.001f) {
                armor *= 1.0f - (shred *= 1.0f - bypassResist);
            }
            if ((pierce = (float)attacker.m_21133_((Attribute)ALAttributes.ARMOR_PIERCE.get())) > 0.001f) {
                armor -= (pierce *= 1.0f - bypassResist);
            }
        }
        if (armor <= 0.0f) {
            return amount;
        }
        return amount * ALCombatRules.getArmorDamageReduction(amount, armor);
    }

    public static float getAValue(float damage) {
        if (damage < 20.0f) {
            return 10.0f;
        }
        return 10.0f + (damage - 20.0f) / 2.0f;
    }

    public static float getArmorDamageReduction(float damage, float armor) {
        float a = ALCombatRules.getAValue(damage);
        return a / (a + armor);
    }
}

