/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketDataFromServer {
    BlockPos pos;
    TypedMap result;
    String command;

    public void toBytes(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.m_130070_(this.command);
        buf.writeBoolean(this.result != null);
        if (this.result != null) {
            TypedMapTools.writeArguments(buf, this.result);
        }
    }

    public PacketDataFromServer(FriendlyByteBuf buf) {
        this.pos = buf.readBoolean() ? buf.m_130135_() : null;
        this.command = buf.m_130136_(Short.MAX_VALUE);
        this.result = buf.readBoolean() ? TypedMapTools.readArguments(buf) : null;
    }

    public PacketDataFromServer(@Nullable BlockPos pos, String command, TypedMap result) {
        this.pos = pos;
        this.command = command;
        this.result = result;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            GenericTileEntity generic;
            BlockEntity te;
            if (this.pos == null) {
                GenericContainer container = PacketDataFromServer.getOpenContainer();
                if (container == null) {
                    Logging.log("Container is missing!");
                    return;
                }
                te = container.getTe();
            } else {
                te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            }
            if (te instanceof GenericTileEntity && (generic = (GenericTileEntity)te).executeClientCommand(this.command, SafeClientTools.getClientPlayer(), this.result)) {
                return;
            }
            Logging.log("Command " + this.command + " was not handled!");
        });
        ctx.setPacketHandled(true);
    }

    private static GenericContainer getOpenContainer() {
        AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
        if (container instanceof GenericContainer) {
            return (GenericContainer)container;
        }
        return null;
    }
}

