/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LogicFacing;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LogicSupport {
    private int powerOutput = 0;

    public static LogicFacing getFacing(BlockState state) {
        return (LogicFacing)((Object)state.m_61143_(LogicSlabBlock.LOGIC_FACING));
    }

    public void setPowerOutput(int powerOutput) {
        this.powerOutput = powerOutput;
    }

    public int getPowerOutput() {
        return this.powerOutput;
    }

    public void setRedstoneState(GenericTileEntity te, int newout) {
        if (this.powerOutput == newout) {
            return;
        }
        this.powerOutput = newout;
        te.m_6596_();
        BlockState state = te.m_58900_();
        Direction outputSide = LogicSupport.getFacing(state).getInputSide().m_122424_();
        te.m_58904_().m_46586_(te.m_58899_().m_121945_(outputSide), state.m_60734_(), te.m_58899_());
    }

    public void checkRedstone(GenericTileEntity te, Level world, BlockPos pos) {
        Direction inputSide = LogicSupport.getFacing(world.m_8055_(pos)).getInputSide();
        int power = this.getInputStrength(world, pos, inputSide);
        te.setPowerInput(power);
    }

    public int getInputStrength(Level world, BlockPos pos, Direction side) {
        BlockState blockState;
        Block b;
        int power = world.m_46681_(pos.m_121945_(side), side);
        if (power < 15 && (b = (blockState = world.m_8055_(pos.m_121945_(side))).m_60734_()) == Blocks.f_50088_) {
            power = Math.max(power, (Integer)blockState.m_61143_((Property)RedStoneWireBlock.f_55500_));
        }
        return power;
    }

    public int getRedstoneOutput(BlockState state, Direction side) {
        if (side == LogicSupport.getFacing(state).getInputSide()) {
            return this.getPowerOutput();
        }
        return 0;
    }
}

