/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei;

import cy.jdkdigital.productivebees.common.item.StoneChip;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import cy.jdkdigital.productivebees.common.recipe.AdvancedBeehiveRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningBigRecipe;
import cy.jdkdigital.productivebees.common.recipe.BeeSpawningRecipe;
import cy.jdkdigital.productivebees.common.recipe.BlockConversionRecipe;
import cy.jdkdigital.productivebees.common.recipe.BottlerRecipe;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.ConfigurableHoneycombRecipe;
import cy.jdkdigital.productivebees.common.recipe.IncubationRecipe;
import cy.jdkdigital.productivebees.container.gui.BottlerScreen;
import cy.jdkdigital.productivebees.container.gui.BreedingChamberScreen;
import cy.jdkdigital.productivebees.container.gui.CentrifugeScreen;
import cy.jdkdigital.productivebees.container.gui.IncubatorScreen;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.integrations.jei.AdvancedBeehiveRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeBreedingRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeConversionRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeFishingRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeFloweringRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeBigCategory;
import cy.jdkdigital.productivebees.integrations.jei.BeeSpawningRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BlockConversionRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.BottlerRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.CentrifugeRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.IncubationRecipeCategory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientHelper;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientRenderer;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class ProductiveBeesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = new ResourceLocation("productivebees", "productivebees");
    public static final RecipeType<AdvancedBeehiveRecipe> ADVANCED_BEEHIVE_TYPE = RecipeType.create((String)"productivebees", (String)"advanced_beehive", AdvancedBeehiveRecipe.class);
    public static final RecipeType<BeeBreedingRecipe> BEE_BREEDING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_breeding", BeeBreedingRecipe.class);
    public static final RecipeType<BeeConversionRecipe> BEE_CONVERSION_TYPE = RecipeType.create((String)"productivebees", (String)"bee_conversion", BeeConversionRecipe.class);
    public static final RecipeType<BeeFishingRecipe> BEE_FISHING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_fishing", BeeFishingRecipe.class);
    public static final RecipeType<BeeSpawningRecipe> BEE_SPAWNING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_spawning", BeeSpawningRecipe.class);
    public static final RecipeType<BeeSpawningBigRecipe> BEE_SPAWNING_BIG_TYPE = RecipeType.create((String)"productivebees", (String)"bee_spawning_big", BeeSpawningBigRecipe.class);
    public static final RecipeType<CentrifugeRecipe> CENTRIFUGE_TYPE = RecipeType.create((String)"productivebees", (String)"centrifuge", CentrifugeRecipe.class);
    public static final RecipeType<BeeFloweringRecipeCategory.Recipe> BEE_FLOWERING_TYPE = RecipeType.create((String)"productivebees", (String)"bee_flowering", BeeFloweringRecipeCategory.Recipe.class);
    public static final RecipeType<IncubationRecipe> INCUBATION_TYPE = RecipeType.create((String)"productivebees", (String)"incubation", IncubationRecipe.class);
    public static final RecipeType<BlockConversionRecipe> BLOCK_CONVERSION_TYPE = RecipeType.create((String)"productivebees", (String)"block_conversion", BlockConversionRecipe.class);
    public static final RecipeType<BottlerRecipe> BOTTLER_TYPE = RecipeType.create((String)"productivebees", (String)"bottler", BottlerRecipe.class);
    public static final IIngredientType<BeeIngredient> BEE_INGREDIENT = () -> BeeIngredient.class;

    public ProductiveBeesJeiPlugin() {
        BeeIngredientFactory.getOrCreateList();
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ADVANCED_OAK_BEEHIVE.get()), new RecipeType[]{ADVANCED_BEEHIVE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CENTRIFUGE.get()), new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.POWERED_CENTRIFUGE.get()), new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.HEATED_CENTRIFUGE.get()), new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COARSE_DIRT_NEST.get()), new RecipeType[]{BEE_SPAWNING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.OAK_WOOD_NEST.get()), new RecipeType[]{BEE_SPAWNING_BIG_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()), new RecipeType[]{INCUBATION_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BOTTLER.get()), new RecipeType[]{BOTTLER_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BREEDING_CHAMBER.get()), new RecipeType[]{BEE_BREEDING_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AdvancedBeehiveRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeBreedingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CentrifugeRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFishingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeSpawningRecipeBigCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BeeFloweringRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubationRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlockConversionRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new BottlerRecipeCategory(guiHelper)});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        Collection<BeeIngredient> ingredients = BeeIngredientFactory.getOrCreateList(true).values();
        registration.register(BEE_INGREDIENT, new ArrayList<BeeIngredient>(ingredients), (IIngredientHelper)new BeeIngredientHelper(), (IIngredientRenderer)new BeeIngredientRenderer());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.WOOD_CHIP.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.STONE_CHIP.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_HONEYCOMB.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_SPAWN_EGG.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CONFIGURABLE_COMB_BLOCK.get()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        Map advancedBeehiveRecipesMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ADVANCED_BEEHIVE_TYPE.get());
        registration.addRecipes(ADVANCED_BEEHIVE_TYPE, advancedBeehiveRecipesMap.values().stream().toList());
        Map centrifugeRecipesMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get());
        registration.addRecipes(CENTRIFUGE_TYPE, centrifugeRecipesMap.values().stream().toList());
        Map fishingRecipesMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_FISHING_TYPE.get());
        registration.addRecipes(BEE_FISHING_TYPE, fishingRecipesMap.values().stream().toList());
        Map beeSpawningRecipesMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_SPAWNING_TYPE.get());
        registration.addRecipes(BEE_SPAWNING_TYPE, beeSpawningRecipesMap.values().stream().toList());
        Map beeSpawningRecipesBigMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_SPAWNING_BIG_TYPE.get());
        registration.addRecipes(BEE_SPAWNING_BIG_TYPE, beeSpawningRecipesBigMap.values().stream().toList());
        Map beeBreedingRecipeMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get());
        registration.addRecipes(BEE_BREEDING_TYPE, beeBreedingRecipeMap.values().stream().toList());
        Map beeConversionRecipeMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BEE_CONVERSION_TYPE.get());
        registration.addRecipes(BEE_CONVERSION_TYPE, beeConversionRecipeMap.values().stream().toList());
        Map blockConversionRecipeMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BLOCK_CONVERSION_TYPE.get());
        registration.addRecipes(BLOCK_CONVERSION_TYPE, blockConversionRecipeMap.values().stream().toList());
        Map bottlerRecipeMap = recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.BOTTLER_TYPE.get());
        registration.addRecipes(BOTTLER_TYPE, bottlerRecipeMap.values().stream().toList());
        List<String> notInfoBees = Arrays.asList("minecraft:bee", "configurable_bee");
        Map<String, BeeIngredient> beeList = BeeIngredientFactory.getOrCreateList();
        for (Map.Entry<String, BeeIngredient> entry : beeList.entrySet()) {
            String beeId = entry.getKey().replace("productivebees:", "");
            if (notInfoBees.contains(beeId)) continue;
            MutableComponent description = Component.m_237113_((String)"");
            if (entry.getValue().isConfigurable()) {
                CompoundTag nbt = BeeReloadListener.INSTANCE.getData(entry.getKey());
                if (nbt.m_128441_("description")) {
                    description = Component.m_237115_((String)nbt.m_128461_("description"));
                }
                if (!nbt.m_128471_("selfbreed")) {
                    description = Component.m_237110_((String)"productivebees.ingredient.description.selfbreed", (Object[])new Object[]{description});
                }
            } else {
                description = Component.m_237115_((String)("productivebees.ingredient.description." + beeId));
                if (beeId.equals("lumber_bee") || beeId.equals("quarry_bee") || beeId.equals("rancher_bee") || beeId.equals("collector_bee") || beeId.equals("hoarder_bee") || beeId.equals("farmer_bee") || beeId.equals("cupid_bee")) {
                    description = Component.m_237110_((String)"productivebees.ingredient.description.selfbreed", (Object[])new Object[]{description});
                }
            }
            if (description.getString().isEmpty()) continue;
            registration.addIngredientInfo((Object)entry.getValue(), BEE_INGREDIENT, new Component[]{description});
        }
        registration.addRecipes(BEE_FLOWERING_TYPE, BeeFloweringRecipeCategory.getFlowersRecipes(beeList));
        registration.addRecipes(INCUBATION_TYPE, IncubationRecipeCategory.getRecipes(beeList));
        List<String> itemInfos = Arrays.asList("inactive_dragon_egg", "dragon_egg_hive", "bumble_bee_nest", "sugar_cane_nest", "slimy_nest", "stone_nest", "sand_nest", "snow_nest", "gravel_nest", "coarse_dirt_nest", "oak_wood_nest", "spruce_wood_nest", "acacia_wood_nest", "dark_oak_wood_nest", "jungle_wood_nest", "birch_wood_nest", "end_stone_nest", "obsidian_nest", "glowstone_nest", "soul_sand_nest", "nether_brick_nest", "nether_quartz_nest");
        for (String itemName : itemInfos) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", itemName));
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("productivebees.ingredient.description." + itemName))});
        }
        ArrayList chipRecipes = new ArrayList();
        ArrayList chipHiveRecipes = new ArrayList();
        Registry.f_122824_.m_206058_(ModTags.QUARRY).forEach(blockHolder -> {
            Block b = (Block)blockHolder.m_203334_();
            chipRecipes.add(StoneChip.getRecipe(b));
            String id = ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_();
            HashMap<Ingredient, IntArrayTag> blockItemOutput = new HashMap<Ingredient, IntArrayTag>();
            blockItemOutput.put(Ingredient.m_43929_((ItemLike[])new ItemLike[]{b.m_5456_()}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "stone_chip_block_hive_" + id), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:quarry_bee")), blockItemOutput));
            HashMap<Ingredient, IntArrayTag> chipItemOutput = new HashMap<Ingredient, IntArrayTag>();
            chipItemOutput.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{StoneChip.getStack(b)}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "stone_chip_hive_" + id), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:quarry_bee")), chipItemOutput));
        });
        Registry.f_122824_.m_206058_(ModTags.LUMBER).forEach(blockHolder -> {
            Block b = (Block)blockHolder.m_203334_();
            chipRecipes.add(WoodChip.getRecipe(b));
            String id = ForgeRegistries.BLOCKS.getKey((Object)b).m_135815_();
            HashMap<Ingredient, IntArrayTag> blockItemOutput = new HashMap<Ingredient, IntArrayTag>();
            blockItemOutput.put(Ingredient.m_43929_((ItemLike[])new ItemLike[]{b.m_5456_()}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "wood_chip_block_hive_" + id), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:lumber_bee")), blockItemOutput));
            HashMap<Ingredient, IntArrayTag> chipItemOutput = new HashMap<Ingredient, IntArrayTag>();
            chipItemOutput.put(Ingredient.m_43927_((ItemStack[])new ItemStack[]{WoodChip.getStack(b)}), new IntArrayTag(new int[]{1, 7, 100}));
            chipHiveRecipes.add(new AdvancedBeehiveRecipe(new ResourceLocation("productivebees", "wood_chip_hive_" + id), (Lazy<BeeIngredient>)Lazy.of(() -> (BeeIngredient)beeList.get("productivebees:lumber_bee")), chipItemOutput));
        });
        registration.addRecipes(RecipeTypes.CRAFTING, chipRecipes.stream().toList());
        registration.addRecipes(ADVANCED_BEEHIVE_TYPE, chipHiveRecipes.stream().toList());
        Optional honeycombRecipe = recipeManager.m_44043_(new ResourceLocation("productivebees", "comb_block/configurable_honeycomb"));
        int count = 4;
        if (honeycombRecipe.isPresent()) {
            count = ((ConfigurableHoneycombRecipe)honeycombRecipe.get()).count;
        }
        ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
        for (Map.Entry<String, CompoundTag> entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
            String beeType = entry.getKey();
            ResourceLocation idComb = new ResourceLocation(beeType + "_honeycomb");
            ResourceLocation idCombBlock = new ResourceLocation(beeType + "_comb");
            ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
            BeeCreator.setTag(beeType, comb);
            NonNullList combInput = NonNullList.m_122779_();
            for (int i = 0; i < count; ++i) {
                combInput.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{comb}));
            }
            ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
            BeeCreator.setTag(beeType, combBlock);
            NonNullList combBlockInput = NonNullList.m_122779_();
            combBlockInput.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{combBlock}));
            recipes.add(new ShapelessRecipe(idComb, "", combBlock, combInput));
            ItemStack combOutput = comb.m_41777_();
            combOutput.m_41764_(count);
            recipes.add(new ShapelessRecipe(idCombBlock, "", combOutput, combBlockInput));
        }
        registration.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CentrifugeScreen.class, 35, 35, 24, 16, new RecipeType[]{CENTRIFUGE_TYPE});
        registration.addRecipeClickArea(BottlerScreen.class, 142, 37, 14, 14, new RecipeType[]{BOTTLER_TYPE});
        registration.addRecipeClickArea(BreedingChamberScreen.class, 72, 14, 45, 22, new RecipeType[]{BEE_BREEDING_TYPE});
        registration.addRecipeClickArea(IncubatorScreen.class, 64, 35, 14, 16, new RecipeType[]{INCUBATION_TYPE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        Collection<BeeIngredient> ingredients = BeeIngredientFactory.getRBeesIngredients().values();
        if (ingredients.size() > 0) {
            jeiRuntime.getIngredientManager().removeIngredientsAtRuntime(BEE_INGREDIENT, new ArrayList<BeeIngredient>(ingredients));
        }
    }
}

