/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.integrations.jei.ingredients;

import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeIngredient {
    private static Map<BeeIngredient, Entity> cache = new HashMap<BeeIngredient, Entity>();
    private EntityType<? extends Entity> bee;
    private ResourceLocation beeType;
    private boolean configurable = false;

    public BeeIngredient(EntityType<? extends Entity> bee) {
        this.bee = bee;
    }

    public BeeIngredient(EntityType<? extends Entity> bee, ResourceLocation beeType) {
        this(bee);
        this.beeType = beeType;
    }

    public BeeIngredient(EntityType<? extends Entity> bee, ResourceLocation beeType, boolean isConfigurable) {
        this(bee);
        this.beeType = beeType;
        this.configurable = isConfigurable;
    }

    public EntityType<? extends Entity> getBeeEntity() {
        return this.bee;
    }

    public Entity getCachedEntity(Level world) {
        if (!cache.containsKey(this)) {
            Entity newBee = this.getBeeEntity().m_20615_(world);
            if (newBee instanceof ConfigurableBee) {
                ((ConfigurableBee)newBee).setBeeType(this.getBeeType().toString());
                ((ConfigurableBee)newBee).setAttributes();
            }
            cache.put(this, newBee);
        }
        return cache.getOrDefault(this, null);
    }

    public ResourceLocation getBeeType() {
        return this.beeType != null ? this.beeType : ForgeRegistries.ENTITY_TYPES.getKey(this.bee);
    }

    public static BeeIngredient fromNetwork(FriendlyByteBuf buffer) {
        String beeName = buffer.m_130277_();
        return new BeeIngredient((EntityType<? extends Entity>)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(beeName))), buffer.m_130281_(), buffer.readBoolean());
    }

    public final void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_("" + ForgeRegistries.ENTITY_TYPES.getKey(this.bee));
        buffer.m_130085_(this.getBeeType());
        buffer.writeBoolean(this.configurable);
    }

    public String toString() {
        return "BeeIngredient{bee=" + this.bee + ", beeType=" + this.beeType + "}";
    }

    public boolean isConfigurable() {
        return this.configurable;
    }
}

