/*
 * Decompiled with CFR 0.152.
 */
package teamsstages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import teamsstages.utils.StageTypes;

@Mod.EventBusSubscriber(modid="teamsstages", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Configs {
    public static final ServerConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Map<String, StageTypes> TypePerStage;
    public static StageTypes defaultStageType;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            Configs.bakeConfig();
        }
    }

    public static void bakeConfig() {
        TypePerStage.clear();
        defaultStageType = (StageTypes)((Object)Configs.COMMON.defaultStageType.get());
        ((List)Configs.COMMON.BothList.get()).forEach(stage -> TypePerStage.put((String)stage, StageTypes.Both));
        ((List)Configs.COMMON.PlayerList.get()).forEach(stage -> TypePerStage.put((String)stage, StageTypes.Player));
        ((List)Configs.COMMON.TeamList.get()).forEach(stage -> TypePerStage.put((String)stage, StageTypes.Team));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (ServerConfig)specPair.getLeft();
        TypePerStage = new HashMap<String, StageTypes>();
        defaultStageType = StageTypes.Both;
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> BothList;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> PlayerList;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> TeamList;
        public final ForgeConfigSpec.EnumValue<StageTypes> defaultStageType;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.defaultStageType = builder.defineEnum("Default stage type", (Enum)StageTypes.Both);
            this.BothList = builder.defineList("Both list", ArrayList::new, this::isString);
            this.PlayerList = builder.defineList("Player list", ArrayList::new, this::isString);
            this.TeamList = builder.defineList("Team list", ArrayList::new, this::isString);
        }

        private boolean isString(Object o) {
            return o == null || o instanceof String;
        }
    }
}

