/*
 * Decompiled with CFR 0.152.
 */
package teamsstages;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.UUID;
import java.util.stream.Collectors;
import net.darkhax.gamestages.command.StageArgumentType;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import teamsstages.utils.TeamsStagesUtils;

public class TeamsStagesCommands {
    public static void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"gamestage");
        TeamsStagesCommands.addSilentTeamStageCommand((LiteralArgumentBuilder<CommandSourceStack>)command, "addTeam", 2, (Command<CommandSourceStack>)((Command)ctx -> TeamsStagesCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, false)), (Command<CommandSourceStack>)((Command)ctx -> TeamsStagesCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, true)));
        TeamsStagesCommands.addSilentTeamStageCommand((LiteralArgumentBuilder<CommandSourceStack>)command, "removeTeam", 2, (Command<CommandSourceStack>)((Command)ctx -> TeamsStagesCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, false)), (Command<CommandSourceStack>)((Command)ctx -> TeamsStagesCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, true)));
        TeamsStagesCommands.addTeamCommand((LiteralArgumentBuilder<CommandSourceStack>)command, "infoTeam", 0, (Command<CommandSourceStack>)((Command)ctx -> TeamsStagesCommands.getStagesInfo((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> TeamsStagesCommands.getStagesInfo((CommandContext<CommandSourceStack>)ctx, false)));
        event.getDispatcher().register(command);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> addSilentTeamStageCommand(LiteralArgumentBuilder<CommandSourceStack> root, String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> silent) {
        return (LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)).then(Commands.m_82129_((String)"silent", (ArgumentType)BoolArgumentType.bool()).executes(silent)))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> addTeamCommand(LiteralArgumentBuilder<CommandSourceStack> root, String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        return (LiteralArgumentBuilder)root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).executes(commandNoPlayer)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(command)));
    }

    private static int getStagesInfo(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        ServerPlayer player = hasPlayer ? EntityArgument.m_91474_(ctx, (String)"target") : ((CommandSourceStack)ctx.getSource()).m_81375_();
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.m_20148_());
        if (team != null) {
            String stageInfo = TeamsStagesUtils.getTeamData(team).getStages().stream().map(Object::toString).collect(Collectors.joining(", "));
            if (stageInfo.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.gamestage.info.empty", (Object[])new Object[]{team.getDisplayName()}), false);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237110_((String)"commands.gamestage.info.stages", (Object[])new Object[]{team.getDisplayName(), stageInfo}), false);
            }
        }
        return 0;
    }

    private static int changeStages(CommandContext<CommandSourceStack> ctx, boolean adding, boolean silent) throws CommandSyntaxException {
        String stageName = StageArgumentType.getStage(ctx, (String)"stage");
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"target");
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.m_20148_());
        if (team != null) {
            IStageData gamestages = TeamsStagesUtils.getTeamData(team);
            if (adding) {
                gamestages.addStage(stageName);
            } else {
                gamestages.removeStage(stageName);
            }
            team.save();
            if (!silent || !BoolArgumentType.getBool(ctx, (String)"silent")) {
                ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237110_((String)(adding ? "commands.teamstage.add.target" : "commands.teamstage.remove.target"), (Object[])new Object[]{stageName}), true);
                if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
                    ((CommandSourceStack)ctx.getSource()).m_81354_((Component)Component.m_237110_((String)(adding ? "commands.gamestage.add.sender" : "commands.gamestage.remove.sender"), (Object[])new Object[]{stageName, team.getDisplayName()}), true);
                }
            }
        }
        return 0;
    }
}

