/*
 * Decompiled with CFR 0.152.
 */
package teamsstages;

import dev.architectury.event.events.common.PlayerEvent;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import teamsstages.network.SyncStagesPacket;
import teamsstages.utils.TeamsStagesUtils;

public class TeamsStagesHandler {
    public static final Map<UUID, IStageData> DATA = new HashMap<UUID, IStageData>();

    public static void init() {
        TeamEvent.LOADED.register(TeamsStagesHandler::onTeamLoad);
        TeamEvent.SAVED.register(TeamsStagesHandler::onTeamSave);
        TeamEvent.CREATED.register(TeamsStagesHandler::onTeamCreation);
        TeamEvent.DELETED.register(TeamsStagesHandler::onTeamDeletion);
        PlayerEvent.PLAYER_JOIN.register(TeamsStagesHandler::onPlayerJoin);
    }

    private static void onPlayerJoin(ServerPlayer player) {
        TeamsStagesHandler.syncData(player, FTBTeamsAPI.getPlayerTeam((UUID)player.m_20148_()));
    }

    private static void onTeamCreation(TeamEvent event) {
        DATA.put(event.getTeam().getId(), (IStageData)new StageData());
    }

    private static void onTeamDeletion(TeamEvent event) {
        DATA.remove(event.getTeam().getId());
    }

    private static void onTeamLoad(TeamEvent event) {
        Team team = event.getTeam();
        Path directory = team.manager.server.m_129843_(TeamManager.FOLDER_NAME);
        Path file = directory.resolve("teamsstages/" + team.getType().m_7912_() + "/" + team.getId() + ".snbt");
        StageData teamData = new StageData();
        if (Files.exists(file, new LinkOption[0])) {
            teamData.readFromNBT((CompoundTag)SNBT.read((Path)file));
        }
        DATA.put(team.getId(), (IStageData)teamData);
    }

    private static void onTeamSave(TeamEvent event) {
        Team team = event.getTeam();
        IStageData teamData = DATA.get(team.getId());
        if (teamData != null) {
            Path directory = team.manager.server.m_129843_(TeamManager.FOLDER_NAME);
            SNBT.write((Path)directory.resolve("teamsstages/" + team.getType().m_7912_() + "/" + team.getId() + ".snbt"), (CompoundTag)teamData.writeToNBT());
        }
    }

    private static void syncData(ServerPlayer player, Team team) {
        IStageData info = TeamsStagesUtils.getTeamData(team);
        if (info != null) {
            new SyncStagesPacket(info.getStages()).sendTo(player);
        }
    }
}

