/*
 * Decompiled with CFR 0.152.
 */
package teamsstages.events;

import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import java.util.UUID;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import teamsstages.Configs;
import teamsstages.utils.StageTypes;
import teamsstages.utils.TeamsStagesUtils;

@Mod.EventBusSubscriber
public class GameStagesEvents {
    private static StageTypes getType(String stage) {
        return Configs.TypePerStage.getOrDefault(stage, Configs.defaultStageType);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onStageCheck(GameStageEvent.Check event) {
        Player player;
        Team team;
        if (!event.hadStageOriginally() && (team = FTBTeamsAPI.getPlayerTeam((UUID)(player = event.getEntity()).m_20148_())) != null) {
            IStageData data = TeamsStagesUtils.getSidedTeamData(player, team);
            boolean hasStage = data.hasStage(event.getStageName());
            event.setHasStage(hasStage);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onStageAdd(GameStageEvent.Add event) {
        StageTypes type = GameStagesEvents.getType(event.getStageName());
        if (type.isTeam()) {
            Player player = event.getEntity();
            Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.m_20148_());
            if (team != null) {
                IStageData data = TeamsStagesUtils.getTeamData(team);
                data.addStage(event.getStageName());
                team.save();
                TeamsStagesUtils.syncAllData(team);
            }
            if (type.isTeamOnly()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onStageRemove(GameStageEvent.Remove event) {
        StageTypes type = GameStagesEvents.getType(event.getStageName());
        if (type.isTeam()) {
            Player player = event.getEntity();
            Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.m_20148_());
            if (team != null) {
                IStageData data = TeamsStagesUtils.getTeamData(team);
                data.removeStage(event.getStageName());
                team.save();
                TeamsStagesUtils.syncAllData(team);
            }
            if (type.isTeamOnly()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onStageClear(GameStageEvent.Cleared event) {
        Player player;
        Team team;
        if (Configs.defaultStageType.isTeam() && (team = FTBTeamsAPI.getPlayerTeam((UUID)(player = event.getEntity()).m_20148_())) != null) {
            IStageData data = TeamsStagesUtils.getTeamData(team);
            data.clear();
            TeamsStagesUtils.syncAllData(team);
        }
    }
}

