/*
 * Decompiled with CFR 0.152.
 */
package teamsstages.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.network.FriendlyByteBuf;
import teamsstages.network.PacketHandler;
import teamsstages.utils.TeamsStagesUtils;

public class SyncStagesPacket
extends BaseS2CMessage {
    private final List<String> stages;

    public SyncStagesPacket(Collection<String> stages) {
        this.stages = new ArrayList<String>(stages);
    }

    public SyncStagesPacket(FriendlyByteBuf buffer) {
        this.stages = Serializers.STRING.fromByteBufList(buffer);
    }

    public List<String> getStages() {
        return this.stages;
    }

    public MessageType getType() {
        return PacketHandler.SYNC;
    }

    public void handle(NetworkManager.PacketContext ctx) {
        StageData clientData = new StageData();
        for (String stageName : this.stages) {
            clientData.addStage(stageName);
        }
        TeamsStagesUtils.setClientData((IStageData)clientData);
    }

    public void write(FriendlyByteBuf buffer) {
        Serializers.STRING.toByteBufList(buffer, this.stages);
    }
}

