/*
 * Decompiled with CFR 0.152.
 */
package teamsstages.utils;

import dev.ftb.mods.ftbteams.data.Team;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import teamsstages.TeamsStagesHandler;
import teamsstages.network.SyncStagesPacket;

public class TeamsStagesUtils {
    @OnlyIn(value=Dist.CLIENT)
    private static IStageData clientData;

    public static IStageData getTeamData(Team team) {
        return TeamsStagesHandler.DATA.get(team.getId());
    }

    public static IStageData getSidedTeamData(Player player, Team team) {
        if (player != null) {
            if (player instanceof ServerPlayer) {
                return TeamsStagesUtils.getTeamData(team);
            }
            if (EffectiveSide.get().isClient()) {
                return TeamsStagesUtils.getClientData();
            }
        }
        return null;
    }

    public static void syncAllData(Team team) {
        IStageData info = TeamsStagesUtils.getTeamData(team);
        if (info != null) {
            new SyncStagesPacket(info.getStages()).sendTo(team.getOnlineMembers());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IStageData getClientData() {
        return clientData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setClientData(IStageData stageData) {
        clientData = stageData;
    }
}

