/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Map;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.OwlModel;
import net.joefoxe.hexerei.client.renderer.entity.render.OwlVariant;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EnergySwirlLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;

public class OwlRenderer
extends MobRenderer<OwlEntity, OwlModel<OwlEntity>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/entity/crow.png");
    private static final ResourceLocation POWER_LOCATION = new ResourceLocation("textures/entity/creeper/creeper_armor.png");
    private final HumanoidModel defaultBipedModel;
    private static final Map<OwlVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(OwlVariant.class), p_114874_ -> p_114874_.put(OwlVariant.HORNED, new ResourceLocation("hexerei", "textures/entity/owl.png")));

    public OwlRenderer(EntityRendererProvider.Context erm) {
        super(erm, new OwlModel(erm.m_174023_(OwlModel.LAYER_LOCATION)), 0.25f);
        this.defaultBipedModel = new HumanoidModel(erm.m_174023_(ModelLayers.f_171261_));
        this.m_115326_((RenderLayer)new OwlPowerLayer((RenderLayerParent<OwlEntity, OwlModel<OwlEntity>>)this, erm.m_174027_()));
    }

    public ResourceLocation getTextureLocation(OwlEntity pEntity) {
        return LOCATION_BY_VARIANT.get((Object)pEntity.getVariant());
    }

    public void render(OwlEntity crowEntity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)crowEntity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void renderItem(ItemStack stack, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    protected void scale(OwlEntity entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        float f = 1.0f;
        if (entitylivingbaseIn.m_6162_()) {
            f *= 0.5f;
            this.f_114477_ = 0.25f;
        } else {
            this.f_114477_ = 0.5f;
        }
        matrixStackIn.m_85841_(f, f, f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class OwlPowerLayer
    extends EnergySwirlLayer<OwlEntity, OwlModel<OwlEntity>> {
        private final OwlModel<OwlEntity> model;

        public OwlPowerLayer(RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> p_174471_, EntityModelSet p_174472_) {
            super(p_174471_);
            this.model = new OwlModel(p_174472_.m_171103_(OwlModel.POWER_LAYER_LOCATION));
        }

        protected float m_7631_(float p_116683_) {
            return p_116683_ * 0.01f;
        }

        protected ResourceLocation m_7029_() {
            return POWER_LOCATION;
        }

        protected EntityModel<OwlEntity> m_7193_() {
            return this.model;
        }
    }

    public class LayerOwlHelmet
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private final RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> renderer;
        private final HumanoidModel<?> defaultBipedModel;
        private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

        public LayerOwlHelmet(OwlRenderer renderer, EntityRendererProvider.Context renderManagerIn) {
            super((RenderLayerParent)renderer);
            this.renderer = renderer;
            this.defaultBipedModel = new HumanoidModel(renderManagerIn.m_174023_(ModelLayers.f_171261_));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity crow, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
            matrixStackIn.m_85836_();
            ItemStack itemstack = crow.itemHandler.getStackInSlot(0);
            Item item = itemstack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armoritem = (ArmorItem)item;
                HumanoidModel<?> a = this.defaultBipedModel;
                boolean notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)crow, itemstack, EquipmentSlot.HEAD, a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlot.HEAD);
                this.translateToHead(matrixStackIn);
                matrixStackIn.m_85841_(0.35f, 0.35f, 0.35f);
                matrixStackIn.m_85837_(0.0, (double)-0.1f, -0.25);
                boolean flag1 = itemstack.m_41790_();
                int clampedLight = packedLightIn;
                if (armoritem instanceof DyeableLeatherItem) {
                    int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderHelmet(crow, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerOwlHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                    this.renderHelmet(crow, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerOwlHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, "overlay"), notAVanillaModel);
                } else {
                    this.renderHelmet(crow, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerOwlHelmet.getArmorResource((Entity)crow, itemstack, EquipmentSlot.HEAD, null), notAVanillaModel);
                }
            } else if (Block.m_49814_((Item)itemstack.m_41720_()) instanceof AbstractSkullBlock) {
                this.translateToHand(matrixStackIn);
                matrixStackIn.m_85841_(0.45f, 0.45f, 0.45f);
                matrixStackIn.m_85837_(0.0, (double)-0.2f, (double)-0.2f);
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.renderItem(itemstack, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.m_85849_();
        }

        private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        }

        private void renderItem(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
        }

        private void renderArmor(OwlEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
            VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
            if (notAVanillaModel) {
                ((OwlModel)this.renderer.m_7200_()).m_102624_((EntityModel)modelIn);
                modelIn.f_102810_.f_104201_ = 0.0f;
                modelIn.f_102808_.m_104227_(0.0f, 1.0f, 0.0f);
                modelIn.f_102809_.f_104201_ = 0.0f;
                modelIn.f_102808_.f_104203_ = ((OwlModel)this.renderer.m_7200_()).body.f_104203_;
                modelIn.f_102808_.f_104204_ = ((OwlModel)this.renderer.m_7200_()).body.f_104204_;
                modelIn.f_102808_.f_104205_ = ((OwlModel)this.renderer.m_7200_()).body.f_104205_;
                modelIn.f_102808_.f_104200_ = ((OwlModel)this.renderer.m_7200_()).body.f_104200_;
                modelIn.f_102808_.f_104201_ = ((OwlModel)this.renderer.m_7200_()).body.f_104201_;
                modelIn.f_102808_.f_104202_ = ((OwlModel)this.renderer.m_7200_()).body.f_104202_;
                modelIn.f_102809_.m_104315_(modelIn.f_102808_);
                modelIn.f_102810_.m_104315_(modelIn.f_102808_);
            }
            modelIn.m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
        }

        private void translateToHead(PoseStack matrixStackIn) {
            this.translateToChest(matrixStackIn);
            ((OwlModel)this.renderer.m_7200_()).head.m_104299_(matrixStackIn);
        }

        private void translateToChest(PoseStack matrixStackIn) {
            ((OwlModel)this.renderer.m_7200_()).body.m_104299_(matrixStackIn);
        }

        private void renderHelmet(OwlEntity entity, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean glintIn, HumanoidModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
            VertexConsumer ivertexbuilder = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
            ((OwlModel)this.renderer.m_7200_()).m_102624_((EntityModel)modelIn);
            modelIn.f_102808_.f_104203_ = 0.0f;
            modelIn.f_102808_.f_104204_ = 0.0f;
            modelIn.f_102808_.f_104205_ = 0.0f;
            modelIn.f_102809_.f_104203_ = 0.0f;
            modelIn.f_102809_.f_104204_ = 0.0f;
            modelIn.f_102809_.f_104205_ = 0.0f;
            modelIn.f_102808_.f_104200_ = 0.0f;
            modelIn.f_102808_.f_104201_ = 0.0f;
            modelIn.f_102808_.f_104202_ = 0.0f;
            modelIn.f_102809_.f_104200_ = 0.0f;
            modelIn.f_102809_.f_104201_ = 0.0f;
            modelIn.f_102809_.f_104202_ = 0.0f;
            modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
        }

        public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            String texture = item.m_40401_().m_6082_();
            String domain = "minecraft";
            int idx = texture.indexOf(58);
            if (idx != -1) {
                domain = texture.substring(0, idx);
                texture = texture.substring(idx + 1);
            }
            String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
            ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
            if (resourcelocation == null) {
                resourcelocation = new ResourceLocation(s1);
                ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
            }
            return resourcelocation;
        }

        protected void setModelSlotVisible(HumanoidModel humanoidModel, EquipmentSlot slotIn) {
            this.setModelVisible(humanoidModel);
            switch (slotIn) {
                case HEAD: {
                    humanoidModel.f_102808_.f_104207_ = true;
                    break;
                }
                case CHEST: {
                    humanoidModel.f_102810_.f_104207_ = true;
                    humanoidModel.f_102811_.f_104207_ = true;
                    humanoidModel.f_102812_.f_104207_ = true;
                    break;
                }
                case LEGS: {
                    humanoidModel.f_102810_.f_104207_ = true;
                    humanoidModel.f_102813_.f_104207_ = true;
                    humanoidModel.f_102814_.f_104207_ = true;
                    break;
                }
                case FEET: {
                    humanoidModel.f_102813_.f_104207_ = true;
                    humanoidModel.f_102814_.f_104207_ = true;
                }
            }
        }

        protected void setModelVisible(HumanoidModel model) {
            model.m_8009_(false);
        }

        protected HumanoidModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel model) {
            Model basicModel = ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, (HumanoidModel)model);
            return basicModel instanceof HumanoidModel ? (HumanoidModel)basicModel : model;
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((OwlModel)this.m_117386_()).body.m_104299_(matrixStack);
            ((OwlModel)this.m_117386_()).body.m_171324_("head").m_104299_(matrixStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LayerOwlMisc
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private static final ResourceLocation CROW_AMULET_LOCATION = new ResourceLocation("hexerei", "textures/entity/crow_amulet.png");

        public LayerOwlMisc(RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> p_117707_) {
            super(p_117707_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity crow, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
            ItemStack itemstack = crow.m_8020_(2);
            if (!crow.m_20145_() && !itemstack.m_41619_()) {
                matrixStackIn.m_85836_();
                this.translateToBody(matrixStackIn);
                matrixStackIn.m_85837_(0.0, (double)-0.15f, (double)-0.165f);
                if (itemstack.m_41720_() instanceof BroomItem) {
                    matrixStackIn.m_85837_((double)0.1f, (double)0.16f, (double)0.01f);
                }
                if (crow.m_6162_()) {
                    matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
                }
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                if (itemstack.m_41720_() instanceof BroomItem) {
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                }
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
                matrixStackIn.m_85841_(0.1f, 0.1f, 0.1f);
                matrixStackIn.m_85849_();
            }
        }

        protected void translateToBody(PoseStack matrixStack) {
            ((OwlModel)this.m_117386_()).owl.m_104299_(matrixStack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class LayerOwlCollar
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        private static final ResourceLocation CROW_COLLAR_LOCATION = new ResourceLocation("hexerei", "textures/entity/crow_collar.png");

        public LayerOwlCollar(RenderLayerParent<OwlEntity, OwlModel<OwlEntity>> p_117707_) {
            super(p_117707_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity entity, float p_117724_, float p_117725_, float p_117726_, float p_117727_, float p_117728_, float p_117729_) {
            if (entity.m_21824_() && !entity.m_20145_() && (entity.getDyeColorId() != -1 || entity.m_7755_().getString().equals("jeb_") || entity.m_7755_().getString().equals("joe_"))) {
                float[] afloat = entity.getDyeColor().m_41068_();
                VertexConsumer vertexConsumer = ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110458_((ResourceLocation)CROW_COLLAR_LOCATION), (boolean)false, (boolean)false);
                ((OwlModel)this.m_117386_()).m_7695_(matrixStackIn, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, afloat[0], afloat[1], afloat[2], 1.0f);
            }
        }
    }

    public class LayerOwlItem
    extends RenderLayer<OwlEntity, OwlModel<OwlEntity>> {
        public LayerOwlItem(OwlRenderer render) {
            super((RenderLayerParent)render);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, OwlEntity crow, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = crow.m_8020_(1);
            matrixStackIn.m_85836_();
            this.translateToHand(matrixStackIn);
            matrixStackIn.m_85837_(0.0, (double)-0.065f, (double)-0.265f);
            if (itemstack.m_41720_() instanceof BroomItem) {
                matrixStackIn.m_85837_((double)0.1f, (double)0.16f, (double)0.01f);
            }
            if (crow.m_6162_()) {
                matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
            }
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-2.5f));
            if (itemstack.m_41720_() instanceof BroomItem) {
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            }
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            matrixStackIn.m_85841_(0.75f, 0.75f, 0.75f);
            ItemStack stack = itemstack.m_41777_();
            if (itemstack.m_41720_() == ModItems.WARHAMMER.get() && crow.m_5446_().getString().equals("Thor") && !itemstack.m_41793_()) {
                stack = EnchantmentHelper.m_220292_((RandomSource)RandomSource.m_216327_(), (ItemStack)itemstack.m_41777_(), (int)1, (boolean)false);
            }
            Minecraft.m_91087_().f_91063_.f_109055_.m_109322_((LivingEntity)crow, stack, ItemTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
        }

        protected void translateToHand(PoseStack matrixStack) {
            ((OwlModel)this.m_117386_()).body.m_104299_(matrixStack);
            ((OwlModel)this.m_117386_()).body.m_171324_("head").m_104299_(matrixStack);
        }
    }
}

