/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.light.LightManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ToggleDynamicLightPacket {
    boolean enabled;

    public ToggleDynamicLightPacket(boolean enabled) {
        this.enabled = enabled;
    }

    public ToggleDynamicLightPacket(FriendlyByteBuf buf) {
        this.enabled = buf.readBoolean();
    }

    public static void encode(ToggleDynamicLightPacket object, FriendlyByteBuf buffer) {
        buffer.writeBoolean(object.enabled);
    }

    public static ToggleDynamicLightPacket decode(FriendlyByteBuf buffer) {
        return new ToggleDynamicLightPacket(buffer);
    }

    public static void consume(ToggleDynamicLightPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Level world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            }
            LightManager.toggleLightsAndConfig(packet.enabled);
        });
        ctx.get().setPacketHandled(true);
    }
}

