/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.repack.org.objectweb.asm.tree;

import java.util.List;
import java.util.Map;
import net.creeperhost.repack.org.objectweb.asm.Label;
import net.creeperhost.repack.org.objectweb.asm.MethodVisitor;
import net.creeperhost.repack.org.objectweb.asm.tree.AbstractInsnNode;
import net.creeperhost.repack.org.objectweb.asm.tree.LabelNode;
import net.creeperhost.repack.org.objectweb.asm.tree.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(LabelNode dflt, int[] keys, LabelNode[] labels) {
        super(171);
        this.dflt = dflt;
        this.keys = Util.asArrayList(keys);
        this.labels = Util.asArrayList(labels);
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        int[] keysArray = new int[this.keys.size()];
        int n = keysArray.length;
        for (int i = 0; i < n; ++i) {
            keysArray[i] = this.keys.get(i);
        }
        Label[] labelsArray = new Label[this.labels.size()];
        int n2 = labelsArray.length;
        for (int i = 0; i < n2; ++i) {
            labelsArray[i] = this.labels.get(i).getLabel();
        }
        methodVisitor.visitLookupSwitchInsn(this.dflt.getLabel(), keysArray, labelsArray);
        this.acceptAnnotations(methodVisitor);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> clonedLabels) {
        LookupSwitchInsnNode clone = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, clonedLabels), null, LookupSwitchInsnNode.clone(this.labels, clonedLabels));
        clone.keys.addAll(this.keys);
        return clone.cloneAnnotations(this);
    }
}

