/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.lib.chat.ChatAuth;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.session.MineTogetherSession;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChatAuthImpl
implements ChatAuth {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Minecraft mc;
    private final UUID uuid;
    private final String uuidHash;

    public ChatAuthImpl(Minecraft mc) {
        this.mc = mc;
        this.uuid = UUIDUtil.m_235875_((GameProfile)mc.m_91094_().m_92548_());
        this.uuidHash = Hashing.sha256().hashString((CharSequence)this.uuid.toString(), StandardCharsets.UTF_8).toString().toUpperCase(Locale.ROOT);
    }

    @Override
    public String getSignature() {
        return MineTogether.FINGERPRINT;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getHash() {
        return this.uuidHash;
    }

    @Override
    @Nullable
    public JWebToken getSessionToken() {
        try {
            return MineTogetherSession.getDefault().getTokenAsync().get();
        }
        catch (InterruptedException | ExecutionException ex) {
            LOGGER.error("Error whilst waiting for token.", (Throwable)ex);
            return null;
        }
    }

    @Deprecated
    public String beginMojangAuth() {
        String serverId = Hashing.sha1().hashString((CharSequence)UUID.randomUUID().toString(), StandardCharsets.UTF_8).toString();
        try {
            this.mc.m_91108_().joinServer(this.mc.m_91094_().m_92548_(), this.mc.m_91094_().m_92547_(), serverId);
            return serverId;
        }
        catch (AuthenticationException ex) {
            LOGGER.error("Failed to send 'joinServer' request.", (Throwable)ex);
            return null;
        }
    }
}

