/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatMonitor;
import net.creeperhost.minetogether.chat.gui.FriendElement;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.chat.gui.MessageElement;
import net.creeperhost.minetogether.chat.gui.PublicChatGui;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.gui.SettingGui;
import net.creeperhost.minetogether.gui.dialogs.OptionDialog;
import net.creeperhost.minetogether.gui.dialogs.TextInputDialog;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.TextState;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class FriendChatGui
implements GuiProvider {
    public final ChatMonitor chatMonitor = new ChatMonitor();
    private GuiTextField textField;
    private GuiTextField friendSearch;
    private GuiList<FriendElement> friendList;
    private GuiElement<?> friendListBg;
    private GuiElement<?> textBoxBg;
    private GuiElement<?> chatBg;
    private GuiElement<?> codeBoxBg;
    private GuiButton publicChat;
    private int friendCookie = -1;
    @Nullable
    protected static Profile selected;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    public void buildGui(ModularGui gui) {
        ProfileManager profileManager;
        List<Profile> knownUsers;
        LinkedList<Profile> friends;
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.m_237115_((String)"minetogether:gui.friends.title"));
        GuiElement root = gui.getRoot();
        this.friendListBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)22.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-30.0));
        this.textBoxBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.friendListBg.get(GeoParam.RIGHT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        this.chatBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.textBoxBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.textBoxBg.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.friendListBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.textBoxBg.get(GeoParam.TOP), (double)-4.0));
        this.codeBoxBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)this.friendListBg.get(GeoParam.LEFT), (GeoRef)this.friendListBg.get(GeoParam.RIGHT), (double)-14.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.friendListBg.get(GeoParam.RIGHT), (double)-30.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        this.setupGuiHeader(gui, root);
        this.setupFriendList(root, this.friendListBg);
        this.setupTextBox(this.textBoxBg);
        this.setupChatWindow(this.chatBg);
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, () -> selected == null ? gui.getGuiTitle() : gui.getGuiTitle().m_6881_().m_130946_(" - ").m_130946_(FriendChatGui.displayName(selected))).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.friendSearch.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.chatBg.get(GeoParam.LEFT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.publicChat.get(GeoParam.LEFT), (double)-2.0));
        gui.onTick(this::tickFriendList);
        gui.onTick(this::updateSelected);
        gui.onTick(this.chatMonitor::tick);
        if (selected != null && !(friends = FastStream.of(knownUsers = (profileManager = MineTogetherChat.CHAT_STATE.profileManager).getKnownProfiles()).filter(Profile::isFriend).toLinkedList()).contains(selected)) {
            selected = null;
        }
    }

    private void setupGuiHeader(ModularGui gui, GuiElement<?> root) {
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.m_237115_((String)"minetogether:gui.button.back_arrow")).onPress(() -> gui.mc().m_91152_(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.chatBg.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.friendListBg.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)50.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton settings = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Supplier<Component>)null).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.button.settings.info")})).setTooltipDelay(0)).onPress(() -> gui.mc().m_91152_((Screen)new ModularGuiScreen((GuiProvider)new SettingGui(), gui.getScreen()))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)back.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.chatBg.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)14.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiTexture gear = new GuiTexture((GuiParent)settings, PolyTextures.get((String)"widgets/gear_light"));
        Constraints.bind((ConstrainedGeometry)gear, (ConstrainedGeometry)settings);
        this.publicChat = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Supplier<Component>)null).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.button.global_chat.info")})).setTooltipDelay(0)).onPress(() -> gui.mc().m_91152_((Screen)new ModularGuiScreen(PublicChatGui.createGui(), gui.getParentScreen()))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)back.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)settings.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)16.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiTexture publicIcon = new GuiTexture((GuiParent)this.publicChat, MTTextures.get("buttons/public_chat_light"));
        Constraints.bind((ConstrainedGeometry)publicIcon, (ConstrainedGeometry)this.publicChat, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
    }

    private void setupFriendList(GuiElement<?> root, GuiElement<?> background) {
        this.friendList = new GuiList(background).setDisplayBuilder((list, e) -> e);
        Constraints.bind(this.friendList, background, (double)5.0);
        GuiElement searchBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)90.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        this.friendSearch = new GuiTextField((GuiParent)searchBg).setTextState(TextState.simpleState((String)"", s -> this.scheduleFriendUpdate())).setSuggestion((Component)Component.m_237115_((String)"minetogether:gui.friends.search_suggestion"));
        Constraints.bind((ConstrainedGeometry)this.friendSearch, (ConstrainedGeometry)searchBg, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(background, Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> this.friendList.hiddenSize() > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        ((GuiSlider)scrollBar.primary).setScrollableElement(this.friendList).setSliderState(this.friendList.scrollState());
        ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
        GuiButton copyCode = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, () -> Component.m_237113_((String)FriendChatGui.getFriendCode(profileManager.getOwnProfile()))).onPress(() -> root.mc().f_91068_.m_90911_(FriendChatGui.getFriendCode(MineTogetherChat.getOurProfile()))).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.friends.friend_code.info1"), Component.m_237115_((String)"minetogether:gui.friends.friend_code.info2"), Component.m_237115_((String)"minetogether:gui.friends.friend_code.info3")})).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.codeBoxBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.codeBoxBg.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.friendListBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.codeBoxBg.get(GeoParam.LEFT), (double)-2.0));
        GuiTextField friendCode = (GuiTextField)new GuiTextField(this.codeBoxBg).setSuggestion((Component)Component.m_237115_((String)"minetogether:gui.friends.code_box.suggestion")).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.friends.code_box.info")});
        Constraints.bind((ConstrainedGeometry)friendCode, this.codeBoxBg, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
        GuiButton addFriendViaCode = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonPrimary(root, (Component)Component.m_237115_((String)"minetogether:gui.friends.code_send")).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.friends.code_send.info")})).onPress(() -> {
            if (friendCode.getValue().equals(FriendChatGui.getFriendCode(profileManager.getOwnProfile()))) {
                OptionDialog.simpleInfoDialog(root, (Component)Component.m_237115_((String)"minetogether:gui.friends.error.own_code"));
                return;
            }
            new TextInputDialog((GuiParent<?>)root, (Component)Component.m_237115_((String)"minetogether:screen.friendreq.desc.request"), "").setResultCallback(friendName -> {
                profileManager.sendFriendRequest(friendCode.getValue(), friendName.trim(), success -> MineTogetherChat.simpleToast((Component)Component.m_237115_((String)(success != false ? "minetogether:gui.friends.request_sent" : "minetogether:gui.friends.request_fail"))));
                friendCode.setValue("");
            });
        }).setDisabled(() -> friendCode.getValue().isEmpty()).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.textBoxBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.codeBoxBg.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.codeBoxBg.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.friendListBg.get(GeoParam.RIGHT)));
    }

    private void setupTextBox(GuiElement<?> background) {
        this.textField = new GuiTextField(background).setMaxLength(256).setOnEditComplete(() -> {
            String message = this.textField.getValue().trim();
            if (!message.isEmpty()) {
                this.textField.setValue("");
                if (this.chatMonitor.getChannel() != null) {
                    this.chatMonitor.getChannel().sendMessage(message);
                }
            }
        });
        Constraints.bind((ConstrainedGeometry)this.textField, background, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
    }

    private void setupChatWindow(GuiElement<?> background) {
        GuiList chatList = new GuiList(background);
        chatList.setDisplayBuilder((parent, message) -> new MessageElement((GuiList<?>)parent, (Message)message, this.textField, true));
        Constraints.bind((ConstrainedGeometry)chatList, background, (double)2.0);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(background, Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> chatList.hiddenSize() > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)background.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)background.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)6.0));
        ((GuiSlider)scrollBar.primary).setScrollableElement((GuiElement)chatList).setSliderState(chatList.scrollState());
        this.chatMonitor.onMessagesUpdated(messages -> {
            double lastHidden = chatList.hiddenSize();
            double pos = chatList.scrollState().getPos();
            chatList.getList().clear();
            chatList.getList().addAll(messages);
            chatList.rebuildElements();
            double newHidden = chatList.hiddenSize();
            if (newHidden != lastHidden && pos != 0.0 && pos != 1.0) {
                double pxlPos = lastHidden * pos;
                chatList.scrollState().setPos(pxlPos / newHidden);
            }
        });
        chatList.scrollState().setPos(1.0);
    }

    private void tickFriendList() {
        ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
        int newCookie = profileManager.getFriendUpdateCookie();
        if (this.friendCookie == newCookie) {
            return;
        }
        this.friendCookie = newCookie;
        List<Profile> knownUsers = profileManager.getKnownProfiles();
        LinkedList<Profile> friends = FastStream.of(knownUsers).filter(Profile::isFriend).toLinkedList();
        friends.sort(Comparator.comparing(FriendChatGui::displayName, (o1, o2) -> {
            int res = String.CASE_INSENSITIVE_ORDER.compare(o1, o2);
            return res == 0 ? o1.compareTo((String)o2) : res;
        }));
        friends.sort(Comparator.comparingInt(e -> e.isOnline() ? 0 : 1));
        this.friendList.getList().clear();
        this.friendList.markDirty();
        String search = this.friendSearch.getValue();
        for (Profile friend : friends) {
            if (!search.isEmpty() && !FriendChatGui.displayName(friend).toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            this.friendList.add((Object)new FriendElement((GuiParent<?>)this.friendList, friend));
        }
        List<ProfileManager.FriendRequest> requests = profileManager.getFriendRequests();
        if (requests.isEmpty()) {
            return;
        }
        this.friendList.add((Object)new FriendElement((GuiParent<?>)this.friendList, (Profile)null));
        for (ProfileManager.FriendRequest request : requests) {
            if (!search.isEmpty() && !FriendChatGui.displayName(request.user).toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
            this.friendList.add((Object)new FriendElement((GuiParent<?>)this.friendList, request));
        }
    }

    private void updateSelected() {
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        boolean textBoxActive = false;
        if (selected != null && state == IrcState.CONNECTED) {
            IrcUser user = MineTogetherChat.CHAT_STATE.ircClient.getUser(selected);
            if (user != null) {
                this.chatMonitor.attach(user.getChannel());
                textBoxActive = true;
            } else {
                this.chatMonitor.attach(null);
                this.textField.setSuggestion((Component)Component.m_237115_((String)"minetogether:gui.friends.user_offline"));
            }
        } else {
            this.chatMonitor.attach(null);
            if (state == IrcState.CONNECTED) {
                this.textField.setSuggestion((Component)Component.m_237115_((String)"minetogether:gui.friends.select_friend"));
            } else {
                this.textField.setSuggestion((Component)Component.m_237113_((String)ChatConstants.STATE_DESC_LOOKUP.get((Object)state)));
            }
        }
        if (textBoxActive) {
            this.textField.setEditable(true);
            this.textField.setFocusable(true);
            this.textField.setFocus(true);
            this.textField.setSuggestion((Supplier)null);
        } else {
            this.textField.setEditable(false);
            this.textField.setFocusable(false);
            this.textField.setFocus(false);
        }
    }

    public static String displayName(@Nullable Profile profile) {
        return profile == null ? "" : (profile.isFriend() && profile.hasFriendName() ? profile.getFriendName() : profile.getDisplayName());
    }

    public static String getFriendCode(Profile profile) {
        return profile.hasFriendCode() ? profile.getFriendCode() : "";
    }

    private void scheduleFriendUpdate() {
        this.friendCookie = -1;
    }
}

