/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat.gui;

import java.util.function.Supplier;
import net.creeperhost.minetogether.chat.ChatConstants;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.ChatMonitor;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.chat.gui.MessageElement;
import net.creeperhost.minetogether.chat.gui.NewUserGui;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.gui.SettingGui;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextField;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class PublicChatGui
implements GuiProvider {
    public final ChatMonitor chatMonitor = new ChatMonitor();
    private GuiTextField textField;

    private PublicChatGui() {
    }

    public static GuiProvider createGui() {
        if (MineTogetherChat.isNewUser()) {
            return new NewUserGui();
        }
        return new PublicChatGui();
    }

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    public void buildGui(ModularGui gui) {
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.m_237115_((String)"minetogether:gui.chat.title"));
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        GuiText connectionStatus = ((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root).setTooltipSingle(() -> {
            IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
            return Component.m_237113_((String)("(" + ChatConstants.STATE_DESC_LOOKUP.get((Object)state) + ")")).m_130940_(ChatConstants.STATE_FORMAT_LOOKUP.get((Object)state));
        })).setTooltipDelay(0)).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)title.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> title.xCenter() + (double)(title.font().m_92852_((FormattedText)title.getText()) / 2) + 4.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).setTextSupplier(() -> {
            IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
            return Component.m_237113_((String)this.connectIndicator(state)).m_130940_(ChatConstants.STATE_FORMAT_LOOKUP.get((Object)state));
        });
        GuiElement textBoxBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).setEnabled(() -> MineTogetherChat.CHAT_STATE.ircClient.getState() != IrcState.BANNED).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        GuiButton banned = ((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.buttonCaution(root, (Component)Component.m_237115_((String)"minetogether:gui.button.banned").m_130940_(ChatFormatting.UNDERLINE)).setEnabled(() -> MineTogetherChat.CHAT_STATE.ircClient.getState() == IrcState.BANNED)).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.button.banned.info")})).setTooltipDelay(0)).onPress(() -> Util.m_137581_().m_137646_("https://minetogether.io/profile/standing"));
        Constraints.bind((ConstrainedGeometry)banned, (ConstrainedGeometry)textBoxBg);
        GuiElement chatBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)textBoxBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)textBoxBg.get(GeoParam.RIGHT)))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)22.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)textBoxBg.get(GeoParam.TOP), (double)-4.0));
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Component)Component.m_237115_((String)"minetogether:gui.button.back_arrow")).onPress(() -> gui.mc().m_91152_(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)chatBg.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)chatBg.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)50.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton settings = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Supplier<Component>)null).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.button.settings.info")})).setTooltipDelay(0)).onPress(() -> gui.mc().m_91152_((Screen)new ModularGuiScreen((GuiProvider)new SettingGui(), gui.getScreen()))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)back.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)chatBg.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)14.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiTexture gear = new GuiTexture((GuiParent)settings, PolyTextures.get((String)"widgets/gear_light"));
        Constraints.bind((ConstrainedGeometry)gear, (ConstrainedGeometry)settings);
        GuiButton friends = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(root, (Supplier<Component>)null).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.button.friends.info")})).setTooltipDelay(0)).onPress(() -> gui.mc().m_91152_((Screen)new ModularGuiScreen((GuiProvider)new FriendChatGui(), gui.getParentScreen()))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)back.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)settings.get(GeoParam.LEFT), (double)-2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)16.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiTexture publicIcon = new GuiTexture((GuiParent)friends, MTTextures.get("buttons/friend_chat_light"));
        Constraints.bind((ConstrainedGeometry)publicIcon, (ConstrainedGeometry)friends, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        this.textField = new GuiTextField((GuiParent)textBoxBg).setMaxLength(256).setCanLoseFocus(false).setOnEditComplete(() -> {
            String message = this.textField.getValue().trim();
            if (!message.isEmpty()) {
                this.textField.setValue("");
                if (this.chatMonitor.getChannel() != null) {
                    this.chatMonitor.getChannel().sendMessage(message);
                }
            }
        });
        Constraints.bind((ConstrainedGeometry)this.textField, (ConstrainedGeometry)textBoxBg, (double)0.0, (double)3.0, (double)0.0, (double)3.0);
        GuiList chatList = new GuiList((GuiParent)chatBg);
        chatList.setDisplayBuilder((parent, message) -> new MessageElement((GuiList<?>)parent, (Message)message, this.textField));
        Constraints.bind((ConstrainedGeometry)chatList, (ConstrainedGeometry)chatBg, (double)2.0);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(root, Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> chatList.hiddenSize() > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)chatBg.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)chatBg.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)chatBg.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)6.0));
        ((GuiSlider)scrollBar.primary).setScrollableElement((GuiElement)chatList).setSliderState(chatList.scrollState());
        this.chatMonitor.onMessagesUpdated(messages -> {
            double lastHidden = chatList.hiddenSize();
            double pos = chatList.scrollState().getPos();
            chatList.getList().clear();
            chatList.getList().addAll(messages);
            chatList.rebuildElements();
            double newHidden = chatList.hiddenSize();
            if (newHidden != lastHidden && pos != 0.0 && pos != 1.0) {
                double pxlPos = lastHidden * pos;
                chatList.scrollState().setPos(pxlPos / newHidden);
            }
        });
        IrcChannel channel = MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel();
        if (channel != null) {
            this.chatMonitor.attach(channel);
        }
        chatList.scrollState().setPos(1.0);
        gui.onTick(this::tick);
        gui.onClose(this.chatMonitor::onGuiClose);
    }

    private void tick() {
        this.chatMonitor.tick();
        IrcState state = MineTogetherChat.CHAT_STATE.ircClient.getState();
        if (state != IrcState.CONNECTED) {
            this.textField.setFocus(false);
            this.textField.setEditable(false);
            this.textField.setValue("");
            this.textField.setSuggestion((Component)Component.m_237115_((String)ChatConstants.STATE_SUGGESTION_LOOKUP.get((Object)state)));
            return;
        }
        this.textField.setEditable(true);
        this.textField.setFocus(true);
        this.textField.setSuggestion((Supplier)null);
    }

    private String connectIndicator(IrcState state) {
        if (state == IrcState.CONNECTED) {
            return "\u2714";
        }
        if (state == IrcState.CONNECTING || state == IrcState.RECONNECTING || state == IrcState.VERIFYING) {
            return (new String[]{"|", "/", "-", "\\"})[(int)(System.currentTimeMillis() / 100L % 4L)];
        }
        return "\u274c";
    }
}

