/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.com.github.scribejava.core.extractors;

import java.io.IOException;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.JsonNode;
import net.creeperhost.minetogether.com.fasterxml.jackson.databind.ObjectMapper;
import net.creeperhost.minetogether.com.github.scribejava.core.exceptions.OAuthException;
import net.creeperhost.minetogether.com.github.scribejava.core.extractors.TokenExtractor;
import net.creeperhost.minetogether.com.github.scribejava.core.model.OAuth1Token;
import net.creeperhost.minetogether.com.github.scribejava.core.model.Response;
import net.creeperhost.minetogether.com.github.scribejava.core.utils.Preconditions;

public abstract class AbstractOAuth1JSONTokenExtractor<T extends OAuth1Token>
implements TokenExtractor<T> {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Override
    public T extract(Response response) throws IOException {
        String rawBody = response.getBody();
        Preconditions.checkEmptyString(rawBody, "Response body is incorrect. Can't extract a token from an empty string");
        JsonNode body = OBJECT_MAPPER.readTree(rawBody);
        JsonNode token = body.get("oauth_token");
        JsonNode secret = body.get("oauth_token_secret");
        if (token == null || secret == null) {
            throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + rawBody + '\'', null);
        }
        return this.createToken(token.asText(), secret.asText(), rawBody);
    }

    protected abstract T createToken(String var1, String var2, String var3);
}

