/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractChannelHandler<H>
extends SimpleChannelInboundHandler<Packet<H>> {
    private final Logger LOGGER = LogManager.getLogger();
    private long lastPacketTime = 0L;
    protected Channel channel;

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channel = ctx.channel();
    }

    protected final ChannelFuture sendPacket(Packet<?> packet) {
        assert (this.channel != null) : "Not connected.";
        this.lastPacketTime = System.currentTimeMillis();
        return this.channel.writeAndFlush(packet);
    }

    public long getLastPacketTime() {
        return this.lastPacketTime;
    }
}

