/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.netty.packet;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import net.creeperhost.minetogether.connect.lib.netty.DataUtils;
import net.creeperhost.minetogether.connect.lib.netty.PacketCtx;
import net.creeperhost.minetogether.connect.lib.netty.packet.ClientPacketHandler;
import net.creeperhost.minetogether.connect.lib.netty.packet.Packet;
import org.jetbrains.annotations.Nullable;

public final class CFriendServers
implements Packet<ClientPacketHandler> {
    public final List<ServerEntry> servers;

    public CFriendServers(List<ServerEntry> servers) {
        this.servers = ImmutableList.copyOf(servers);
    }

    public CFriendServers(PacketCtx ctx) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = DataUtils.readVarInt(ctx.buf);
        for (int j = 0; j < i; ++j) {
            builder.add((Object)new ServerEntry(DataUtils.readString(ctx.buf), DataUtils.readString(ctx.buf), ctx.buf.readBoolean() ? DataUtils.readString(ctx.buf) : null));
        }
        this.servers = builder.build();
    }

    @Override
    public void write(ByteBuf buf) {
        DataUtils.writeVarInt(buf, this.servers.size());
        for (ServerEntry server : this.servers) {
            DataUtils.writeString(buf, server.friend);
            DataUtils.writeString(buf, server.serverToken);
            buf.writeBoolean(server.node != null);
            if (server.node == null) continue;
            DataUtils.writeString(buf, server.node);
        }
    }

    @Override
    public void handle(ChannelHandlerContext ctx, ClientPacketHandler handler) throws Exception {
        handler.handleFriendServers(ctx, this);
    }

    public static class ServerEntry {
        public final String friend;
        public final String serverToken;
        @Nullable
        public final String node;

        public ServerEntry(String friend, String serverToken, @Nullable String node) {
            this.friend = friend;
            this.serverToken = serverToken;
            this.node = node;
        }
    }
}

