/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect.lib.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.WillClose;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAUtils {
    public static byte[] sign(byte[] bytes, PrivateKey privateKey) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initSign(privateKey);
            sign.update(bytes);
            return sign.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new RuntimeException("Rsa not available??", ex);
        }
    }

    public static boolean isValid(byte[] payload, byte[] signature, PublicKey publicKey) {
        try {
            Signature verify = Signature.getInstance("SHA256withRSA");
            verify.initVerify(publicKey);
            verify.update(payload);
            return verify.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            return false;
        }
    }

    public static byte[] encrypt(byte[] message, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, publicKey);
            return cipher.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException("Failed to encrypt message.", ex);
        }
    }

    public static byte[] decrypt(byte[] message, PrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
            return cipher.doFinal(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            throw new RuntimeException("Failed to encrypt message.", ex);
        }
    }

    public static KeyPair generateRSAKeyPair() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(4096);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Rsa not available??", ex);
        }
    }

    public static PrivateKey loadRSAPrivateKeyPem(Path path) throws IOException {
        return RSAUtils.loadRSAPrivateKey(RSAUtils.loadPem(path));
    }

    public static PrivateKey loadRSAPrivateKeyPem(InputStream is) throws IOException {
        return RSAUtils.loadRSAPrivateKey(RSAUtils.loadPem(is));
    }

    public static PrivateKey loadRSAPrivateKeyPem(byte[] bytes) throws IOException {
        return RSAUtils.loadRSAPrivateKey(RSAUtils.loadPem(bytes));
    }

    public static PrivateKey loadRSAPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load private key.", ex);
        }
    }

    public static PublicKey loadRSAPublicKeyPem(Path path) throws IOException {
        return RSAUtils.loadRSAPublicKey(RSAUtils.loadPem(path));
    }

    public static PublicKey loadRSAPublicKeyPem(InputStream is) throws IOException {
        return RSAUtils.loadRSAPublicKey(RSAUtils.loadPem(is));
    }

    public static PublicKey loadRSAPublicKeyPem(byte[] bytes) throws IOException {
        return RSAUtils.loadRSAPublicKey(RSAUtils.loadPem(bytes));
    }

    public static PublicKey loadRSAPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load public key.", ex);
        }
    }

    public static List<String> encodeRSAKey(PublicKey key) {
        return RSAUtils.writePem(key.getEncoded(), "RSA PUBLIC");
    }

    public static List<String> encodeRSAKey(PrivateKey key) {
        return RSAUtils.writePem(key.getEncoded(), "RSA PRIVATE");
    }

    public static List<String> writePem(byte[] keyData, String type) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("-----BEGIN " + type + " KEY-----");
        String str = Base64.getEncoder().encodeToString(keyData);
        for (int i = 0; i < str.length(); i += 64) {
            lines.add(str.substring(i, Math.min(i + 64, str.length())));
        }
        lines.add("-----END " + type + " KEY-----");
        return lines;
    }

    public static byte[] loadPem(Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            byte[] byArray = RSAUtils.loadPem(is);
            return byArray;
        }
    }

    public static byte[] loadPem(byte[] bytes) throws IOException {
        return RSAUtils.loadPem(new ByteArrayInputStream(bytes));
    }

    public static byte[] loadPem(@WillClose InputStream is) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("--")) continue;
                builder.append(line);
            }
        }
        return Base64.getDecoder().decode(builder.toString());
    }

    public static byte[] loadPem(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("--")) continue;
            builder.append(line);
        }
        return Base64.getDecoder().decode(builder.toString());
    }
}

