/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.util.function.Supplier;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.chat.gui.FriendChatGui;
import net.creeperhost.minetogether.chat.gui.MTStyle;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.gui.MTTextures;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.oauth.KeycloakOAuth;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class SettingGui
implements GuiProvider {
    private boolean showBlocked = false;
    private double blockedAnim;
    private GuiList<Profile> blockedList;

    public GuiElement<?> createRootElement(ModularGui gui) {
        return MTStyle.Flat.background(gui);
    }

    public void buildGui(ModularGui gui) {
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.m_237115_((String)"minetogether:gui.settings.title"));
        GuiElement root = gui.getRoot();
        int panelWidth = 150;
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)10.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0));
        GuiElement settings = (GuiElement)((GuiElement)((GuiElement)((GuiElement)new GuiElement((GuiParent)root).constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.TOP), (GeoRef)root.get(GeoParam.BOTTOM), (double)-70.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.dynamic(() -> this.buttonPanelPos(root)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)panelWidth))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)0.0));
        GuiButton enabled = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(settings, (Component)Component.m_237119_()).onPress(this::toggleEnabled).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        enabled.getLabel().setTextSupplier(() -> Component.m_237115_((String)"minetogether:gui.settings.button.chat").m_7220_(SettingGui.state(Config.instance().chatEnabled)));
        GuiButton menuButtons = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(settings, (Component)Component.m_237119_()).onPress(() -> this.setConfig(() -> Config.instance().mainMenuButtons ^= true)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)enabled.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        menuButtons.getLabel().setTextSupplier(() -> Component.m_237115_((String)"minetogether:gui.settings.button.menu_buttons").m_7220_(SettingGui.state(Config.instance().mainMenuButtons)));
        GuiButton toasts = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(settings, (Component)Component.m_237119_()).onPress(() -> this.setConfig(() -> Config.instance().friendNotifications ^= true)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)menuButtons.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        toasts.getLabel().setTextSupplier(() -> Component.m_237115_((String)"minetogether:gui.settings.button.friend_toasts").m_7220_(SettingGui.state(Config.instance().friendNotifications)));
        GuiButton chatSliders = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(toasts, (Component)Component.m_237119_()).onPress(() -> this.setConfig(() -> Config.instance().chatSettingsSliders ^= true)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)menuButtons.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        chatSliders.getLabel().setTextSupplier(() -> Component.m_237115_((String)"minetogether:gui.settings.button.chat_sliders").m_7220_(SettingGui.state(Config.instance().chatSettingsSliders)));
        GuiButton blocked = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(chatSliders, (Component)Component.m_237115_((String)"minetogether:gui.settings.button.blocked")).onPress(() -> this.setConfig(() -> this.showBlocked ^= true)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)toasts.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        GuiButton link = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(settings, (Component)Component.m_237115_((String)"minetogether:gui.settings.button.link")).onPress(() -> gui.mc().m_91152_((Screen)new ConfirmScreen(b -> {
            if (b) {
                KeycloakOAuth.main(new String[0]);
            }
            gui.mc().m_91152_(gui.getScreen());
        }, (Component)Component.m_237115_((String)"minetogether:linkaccount1"), (Component)Component.m_237115_((String)"minetogether:linkaccount2")))).setDisabled(() -> MineTogetherChat.getOurProfile().hasAccount()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)blocked.get(GeoParam.BOTTOM), (double)4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(settings, (Component)Component.m_237115_((String)"minetogether:gui.button.back")).onPress(() -> gui.mc().m_91152_(gui.getParentScreen())).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)link.get(GeoParam.BOTTOM), (double)24.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)settings.get(GeoParam.RIGHT)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)16.0));
        GuiElement blockedBg = (GuiElement)((GuiElement)((GuiElement)((GuiElement)MTStyle.Flat.contentArea(root).setEnabled(() -> this.blockedAnim == 1.0).constrain(GeoParam.LEFT, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.LEFT), (GeoRef)root.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)panelWidth))).constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.TOP), (GeoRef)root.get(GeoParam.BOTTOM), (double)-90.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.midPoint((GeoRef)root.get(GeoParam.TOP), (GeoRef)root.get(GeoParam.BOTTOM), (double)100.0));
        GuiText blockedTitle = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)blockedBg, (Component)Component.m_237115_((String)"minetogether:gui.settings.button.blocked").m_130940_(ChatFormatting.UNDERLINE)).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)blockedBg.get(GeoParam.TOP), (double)-3.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)blockedBg.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)blockedBg.get(GeoParam.RIGHT)));
        this.blockedList = new GuiList((GuiParent)blockedBg).setDisplayBuilder((x$0, x$1) -> new BlockedEntry((GuiParent<?>)x$0, (Profile)x$1)).setItemSpacing(2.0);
        Constraints.bind(this.blockedList, (ConstrainedGeometry)blockedBg, (double)5.0);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = MTStyle.Flat.scrollBar(blockedBg, Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> this.blockedList.hiddenSize() > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.blockedList.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.blockedList.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)blockedBg.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        ((GuiSlider)scrollBar.primary).setScrollableElement(this.blockedList).setSliderState(this.blockedList.scrollState());
        this.updateBlockedList();
        gui.onTick(this::tick);
        gui.onResize(this::updateBlockedList);
    }

    private void updateBlockedList() {
        this.blockedList.getList().clear();
        this.blockedList.markDirty();
        String search = "";
        for (Profile mutedProfile : MineTogetherChat.CHAT_STATE.profileManager.getMutedProfiles()) {
            if (!StringUtils.isEmpty((CharSequence)search) && !StringUtils.containsAnyIgnoreCase((CharSequence)mutedProfile.getDisplayName(), (CharSequence[])new CharSequence[]{search})) continue;
            this.blockedList.add((Object)mutedProfile);
        }
    }

    private void tick() {
        if (this.showBlocked && this.blockedAnim < 1.0) {
            this.blockedAnim = Math.min(1.0, this.blockedAnim + 0.2);
        } else if (!this.showBlocked && this.blockedAnim > 0.0) {
            this.blockedAnim = Math.max(0.0, this.blockedAnim - 0.2);
        }
    }

    private double buttonPanelPos(GuiElement<?> root) {
        double partial = (this.showBlocked ? 0.2 : -0.2) * (double)Minecraft.m_91087_().m_91296_();
        double anim = MathUtil.clamp((double)(this.blockedAnim + partial), (double)0.0, (double)1.0);
        return root.xCenter() - 75.0 - 80.0 * anim;
    }

    private static Component state(boolean state) {
        if (state) {
            return Component.m_237115_((String)"minetogether:gui.settings.button.enabled").m_130940_(ChatFormatting.GREEN);
        }
        return Component.m_237115_((String)"minetogether:gui.settings.button.disabled").m_130940_(ChatFormatting.RED);
    }

    private void toggleEnabled() {
        Config config = Config.instance();
        if (config.chatEnabled) {
            MineTogetherChat.disableChat();
            config.chatEnabled = false;
        } else {
            MineTogetherChat.enableChat();
            config.chatEnabled = true;
        }
        Config.save();
    }

    private void setConfig(Runnable set) {
        set.run();
        Config.save();
    }

    private class BlockedEntry
    extends GuiElement<BlockedEntry>
    implements BackgroundRender {
        public BlockedEntry(GuiParent<?> parent, Profile profile) {
            super(parent);
            this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
            GuiText name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237119_()).setTextSupplier(() -> Component.m_237113_((String)FriendChatGui.displayName(profile))).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-14.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
            GuiButton unblock = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)MTStyle.Flat.button(this, (Supplier<Component>)null).setTooltip(new Component[]{Component.m_237115_((String)"minetogether:gui.settings.button.unblock.info")})).setTooltipDelay(0)).onPress(() -> {
                profile.unmute();
                SettingGui.this.updateBlockedList();
            }).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.BOTTOM)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)14.0));
            GuiTexture removeTex = new GuiTexture((GuiParent)unblock, MTTextures.get("buttons/delete"));
            Constraints.bind((ConstrainedGeometry)removeTex, (ConstrainedGeometry)unblock, (double)2.0);
        }

        public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            render.rect(this.getRectangle(), MTStyle.Flat.listEntryBackground(true));
        }
    }
}

