/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc.pircbotx;

import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.PMChannel;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import org.jetbrains.annotations.Nullable;

public class PircBotUser
implements IrcUser {
    private final PircBotX client;
    private final Profile profile;
    private final PMChannel channel;
    @Nullable
    private User ircUser;

    public PircBotUser(PircBotX client, ChatState state, Profile profile) {
        this.client = client;
        this.profile = profile;
        this.channel = new PMChannel(state, this);
    }

    void bindIrcUser(@Nullable User ircUser) {
        this.ircUser = ircUser;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public boolean isOnline() {
        return this.ircUser != null;
    }

    @Override
    public IrcChannel getChannel() {
        return this.channel;
    }

    @Override
    public void sendMessage(String message) {
        if (this.ircUser != null) {
            this.ircUser.send().message(message);
        }
    }

    @Override
    public void sendRawCTCP(String command) {
        if (this.ircUser == null) {
            throw new IllegalStateException("User is not online");
        }
        this.client.sendIRC().ctcpCommand(this.ircUser.getNick(), command);
    }
}

